/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.console.queries.tenant;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.tenants.OlapTenantDefinition;
import crazydev.iccube.tenants.OlapTenantManager;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.console.UxConsoleQuery;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxSetTenantQuery
extends UxConsoleQuery {
    @Nullable
    private final String tenantName;

    protected UxSetTenantQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String tenantName) {
        super(meta, requestId);
        this.tenantName = tenantName;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        OlapTenant tenant;
        if (!queryContext.isSuperAdministrator()) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.TENANT_NOT_GLOBAL_ADMINISTRATOR, (Serializable[])new Serializable[0]));
        }
        if (CdStringUtils.isNotNullAndNotBlank((String)this.tenantName)) {
            OlapTenantManager tenants = queryContext.getTenantManager();
            OlapTenantDefinition tenantDefinition = tenants.getTenantDefinitionByName(this.tenantName);
            if (tenantDefinition == null) {
                return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.TENANT_UNKNOWN, (Serializable[])new Serializable[]{this.tenantName}));
            }
            tenant = new OlapTenant(tenantDefinition.getName(), tenantDefinition.getDirectory());
        } else {
            tenant = null;
        }
        queryContext.resetUserTenant(tenant);
        return UxReply.actionSuccess();
    }
}

