/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.console.queries.profile;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.authentication.definition.OlapUserDefinition;
import crazydev.iccube.pub.authentication.IOlapAuthenticationService;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelReplyPayload;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.console.UxConsoleQuery;
import crazydev.iccube.ux.console.queries.profile.UxSaveUserProfileQueryMeta;
import crazydev.iccube.ux.console.queries.profile.UxUserProfileQueryMeta;
import java.io.Serializable;

public class UxUserProfileQuery
extends UxConsoleQuery {
    public UxUserProfileQuery(UxQueryMeta meta, OlapRequestId requestId) {
        super(meta, requestId);
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        String userName;
        if (!queryContext.isAuthServiceEditable()) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.USERS_READ_ONLY, (Serializable[])new Serializable[0]));
        }
        IOlapAuthenticationService service = queryContext.getAuthenticationService();
        OlapUserDefinition user = service.getUserDefinitionByName(userName = queryContext.getUserName());
        if (user == null) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.USER_MISSING_DEFINITION, (Serializable[])new Serializable[0]));
        }
        int revNumber = service.getRevisionNumber();
        boolean requiredPassword = queryContext.isUserDefinitionWithPassword();
        if (!requiredPassword) {
            queryContext.setModelTypeSetupInfo(question -> "NAME_READONLY".equals(question) || "ROLES_READONLY".equals(question) || "NOT_REQUIRED_PASSWORD".equals(question));
        } else {
            queryContext.setModelTypeSetupInfo(question -> "NAME_READONLY".equals(question) || "ROLES_READONLY".equals(question) || "OPTIONAL_PASSWORD".equals(question));
        }
        UxModel model = queryContext.convertToUxModel(revNumber, user);
        UxAction save = UxSaveUserProfileQueryMeta.createAction(queryContext);
        return UxReply.success(new UxModelReplyPayload(model, save));
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(UxUserProfileQueryMeta.createUseCase(queryContext));
    }
}

