/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.console.queries.lix;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.fs.CdVFileSystem;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionError;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorCode;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.info.OlapLixContent;
import crazydev.iccube.info.OlapLixVerifier;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.common.action.UxActionPerformed;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.console.UxConsoleQuery;
import java.io.IOException;
import java.io.Serializable;
import java.util.Base64;

public class UxRegisterLixQuery
extends UxConsoleQuery {
    private final String lix;

    protected UxRegisterLixQuery(UxQueryMeta meta, OlapRequestId requestId, String lix) {
        super(meta, requestId);
        this.lix = lix;
    }

    @Override
    protected boolean isAcceptedForMissing() {
        return true;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        if (!queryContext.isAdministrator()) {
            return UxReply.error(queryContext, new OlapRoleDefinitionError(OlapRoleDefinitionErrorCode.QUERY_NOT_AUTHORIZED, new Serializable[]{UxConsoleConstants.QueryName.RegisterLix.name()}));
        }
        OlapLoggers.REQUEST.info((Object)("[register] [" + this.lix + "]"));
        int base64pos = this.lix.indexOf(",");
        if (base64pos == -1) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.ERROR_UNEXPECTED, (Serializable[])new Serializable[]{"Invalid Data URL."}));
        }
        String base64 = this.lix.substring(base64pos + 1);
        byte[] content = Base64.getDecoder().decode(base64);
        OlapLixContent lixContent = OlapLixVerifier.verifyOnRegister((byte[])content);
        if (lixContent == null) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.ERROR_UNEXPECTED, (Serializable[])new Serializable[]{"Invalid license."}));
        }
        OlapRuntimeContext rContext = queryContext.asRuntimeContext();
        OlapDirectoriesResolved directories = rContext.getDirectoriesResolved();
        CdVFileSystem vfs = rContext.getVfs();
        try {
            vfs.saveLicense(directories.getDataDirectory(), content);
        }
        catch (IOException ex) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.ERROR_UNEXPECTED, (Serializable[])new Serializable[]{"Could not install the license (" + ex.getMessage() + ")."}));
        }
        return UxReply.actionSuccess(new UxActionPerformed(true, "The license has been successfully installed. Please restart your server."));
    }
}

