/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.console.queries.init;

import crazydev.iccube.ux.common.json.UxJsonUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UxJsonResourceBundle
extends ResourceBundle {
    private final Object json;

    public UxJsonResourceBundle(InputStreamReader in) {
        this.json = UxJsonUtils.gson().create().fromJson((Reader)in, Map.class);
    }

    @Override
    @Nullable
    protected Object handleGetObject(@NotNull String key) {
        return "json".equals(key) ? this.json : null;
    }

    @Override
    @NotNull
    public Enumeration<String> getKeys() {
        return Collections.enumeration(Collections.singletonList("json"));
    }

    public static class Control
    extends ResourceBundle.Control {
        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            Locale defaultLocale = Locale.ENGLISH;
            return locale.equals(defaultLocale) ? null : defaultLocale;
        }

        @Override
        public List<String> getFormats(String baseName) {
            if (baseName == null) {
                throw new NullPointerException();
            }
            return Collections.singletonList("json");
        }

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IOException {
            if (baseName == null || locale == null || format == null || loader == null) {
                throw new NullPointerException();
            }
            UxJsonResourceBundle bundle = null;
            if (format.equals("json")) {
                String bundleName = this.toBundleName(baseName, locale);
                String resourceName = this.toResourceName(bundleName, format);
                InputStream stream = null;
                if (reload) {
                    URLConnection connection;
                    URL url = loader.getResource(resourceName);
                    if (url != null && (connection = url.openConnection()) != null) {
                        connection.setUseCaches(false);
                        stream = connection.getInputStream();
                    }
                } else {
                    stream = loader.getResourceAsStream(resourceName);
                }
                if (stream != null) {
                    try (BufferedInputStream in = new BufferedInputStream(stream);
                         InputStreamReader reader = new InputStreamReader((InputStream)in, StandardCharsets.UTF_8);){
                        bundle = new UxJsonResourceBundle(reader);
                    }
                }
            }
            return bundle;
        }
    }
}

