/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.console.queries.init;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.server.configuration.IcCubeServerConfiguration;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.ux.admin.queries.runtime.request.UxCancelRequestExQueryMeta;
import crazydev.iccube.ux.admin.queries.runtime.request.UxRequestQueryMeta;
import crazydev.iccube.ux.admin.queries.users.UxUserPhotoQueryMeta;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseRepository;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.app.UxApp;
import crazydev.iccube.ux.common.app.UxAppType;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.url.UxUrlConstants;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.repository.UxUseCaseRepository;
import crazydev.iccube.ux.console.UxConsoleQuery;
import crazydev.iccube.ux.console.queries.browsing.UxSetBrowsingLocaleQueryMeta;
import crazydev.iccube.ux.console.queries.init.UxConsoleInitDataReplyPayload;
import crazydev.iccube.ux.console.queries.init.UxConsoleInitProperties;
import crazydev.iccube.ux.console.queries.init.UxConsoleLocalization;
import crazydev.iccube.ux.console.queries.init.UxEnvironment;
import crazydev.iccube.ux.console.queries.logout.UxLogoutQueryMeta;
import crazydev.iccube.ux.console.queries.profile.UxUserProfileQueryMeta;
import crazydev.iccube.ux.console.queries.search.UxSearchScope;
import crazydev.iccube.ux.console.queries.search.UxSearchSuggestionsQueryMeta;
import crazydev.iccube.ux.console.queries.tenant.UxSetTenantQueryMeta;
import crazydev.iccube.ux.console.usecase.UxConsoleUseCaseRepository;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class UxConsoleInitDataQuery
extends UxConsoleQuery {
    private final String pathInfo;
    @Nullable
    private final UxSchemaId schemaId;

    UxConsoleInitDataQuery(UxQueryMeta meta, OlapRequestId requestId, String pathInfo, @Nullable UxSchemaId schemaId) {
        super(meta, requestId);
        this.pathInfo = pathInfo;
        this.schemaId = schemaId;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        UxAction searchAction;
        UxUseCase appTitleUC;
        String appTitle;
        UxAction logout;
        UxAction setBrowsingLocale;
        UxAction setTenant;
        UxAppType appType = this.setupAppType();
        String tenantName = queryContext.getUserTenantName();
        String roleName = queryContext.getUserRoleName();
        String usersRevision = queryContext.getUsersRevision();
        String userName = queryContext.getUserName();
        UxUrl userPhoto = UxUserPhotoQueryMeta.UserPhoto.createQueryUrl(userName, usersRevision);
        ArrayList<UxAction> actions = new ArrayList<UxAction>();
        UxAction editProfile = UxUserProfileQueryMeta.createAction(queryContext);
        if (editProfile != null) {
            actions.add(editProfile);
        }
        if ((setTenant = UxSetTenantQueryMeta.createAction(queryContext)) != null) {
            actions.add(setTenant);
        }
        if ((setBrowsingLocale = UxSetBrowsingLocaleQueryMeta.createAction(queryContext)) != null) {
            actions.add(setBrowsingLocale);
        }
        if ((logout = UxLogoutQueryMeta.createAction(queryContext)) != null) {
            actions.add(logout);
        }
        UxBabylonService babylon = queryContext.getUxBabylonService();
        List<UxUseCase> useCases = UxConsoleInitDataQuery.setupUseCases(queryContext, appType, this.schemaId);
        String consoleURL = UxUrlConstants.APP_URL_CONSOLE.toUrl() + "/";
        String searchActionText = switch (appType) {
            case UxAppType.admin -> {
                appTitle = babylon.translate("appAdminTitle", new Serializable[0]);
                appTitleUC = null;
                searchAction = UxSearchSuggestionsQueryMeta.createAction(queryContext, UxSearchScope.admin);
                yield babylon.translate("appAdminSearch", new Serializable[0]);
            }
            case UxAppType.builder -> {
                appTitle = babylon.translate("appBuilderTitle", new Serializable[0]);
                appTitleUC = queryContext.getUseCase(UxBuilderUseCaseName.BuilderHome);
                searchAction = UxSearchSuggestionsQueryMeta.createAction(queryContext, UxSearchScope.builder);
                yield babylon.translate("appBuilderSearch", new Serializable[0]);
            }
            case UxAppType.console -> {
                appTitle = babylon.translate("appConsoleTitle", new Serializable[0]);
                appTitleUC = null;
                searchAction = UxSearchSuggestionsQueryMeta.createAction(queryContext, UxSearchScope.console);
                yield babylon.translate("appConsoleSearch", new Serializable[0]);
            }
            case UxAppType.mdx -> {
                appTitle = babylon.translate("appMdxConsoleTitle", new Serializable[0]);
                appTitleUC = null;
                searchAction = UxSearchSuggestionsQueryMeta.createAction(queryContext, UxSearchScope.mdx);
                yield babylon.translate("appMdxConsoleSearch", new Serializable[0]);
            }
            default -> {
                appTitle = babylon.translate("appConsoleTitle", new Serializable[0]);
                appTitleUC = null;
                searchAction = null;
                yield null;
            }
        };
        List<UxApp> apps = UxConsoleInitDataQuery.setupApps(queryContext, appType);
        Object localization = UxConsoleLocalization.setup(queryContext, appType);
        UxEnvironment environment = this.setupEnvironment(queryContext);
        String ic3_clt_req_uuid_seed = UUID.randomUUID().toString();
        UxAction ic3_clt_req_cancel = UxCancelRequestExQueryMeta.createAction(queryContext);
        UxAction ic3_clt_req_monitor = UxRequestQueryMeta.createActionForMonitor(queryContext);
        UxConsoleInitProperties properties = new UxConsoleInitProperties(UxTableOptions.UX_DEFAULT_PAGE_SIZE, UxTableOptions.UX_DEFAULT_PAGE_SIZES);
        return UxReply.success(new UxConsoleInitDataReplyPayload(ic3_clt_req_uuid_seed, ic3_clt_req_cancel, ic3_clt_req_monitor, consoleURL, appType, appTitle, appTitleUC, useCases, usersRevision, tenantName, roleName, userName, userPhoto, apps, actions, searchAction, searchActionText, localization, environment, properties));
    }

    public static List<UxApp> setupApps(UxQueryContext queryContext, UxAppType appType) {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        ArrayList<UxApp> apps = new ArrayList<UxApp>();
        apps.add(new UxApp("admin", babylon.translate("appAdmin", new Serializable[0]), UxUrlConstants.APP_URL_ADMIN, queryContext.isAppAdminEnabled()));
        apps.add(new UxApp("builder", babylon.translate("appBuilder", new Serializable[0]), UxUrlConstants.APP_URL_BUILDER, queryContext.isAppBuilderEnabled()));
        apps.add(new UxApp("mdxConsole", babylon.translate("appMdxConsole", new Serializable[0]), UxUrlConstants.APP_URL_MDX, queryContext.isAppMdxIdeEnabled()));
        apps.add(new UxApp("dashboards", babylon.translate("appDashboards", new Serializable[0]), UxUrlConstants.APP_URL_DASHBOARDS, queryContext.isAppReportingEnabled()));
        apps.add(new UxApp("help", babylon.translate("appHelp", new Serializable[0]), UxUrlConstants.APP_URL_HELP, true));
        return apps;
    }

    public static List<UxUseCase> setupUseCases(UxQueryContext queryContext, UxAppType appType, @Nullable UxSchemaId schemaId) {
        return switch (appType) {
            case UxAppType.admin -> UxConsoleInitDataQuery.setupAdminUseCases(queryContext);
            case UxAppType.builder -> UxConsoleInitDataQuery.setupBuilderUseCases(queryContext, schemaId);
            case UxAppType.console -> UxConsoleInitDataQuery.setupConsoleUseCases(queryContext);
            default -> new ArrayList();
        };
    }

    public static List<UxUseCase> setupAdminUseCases(UxQueryContext queryContext) {
        UxAdminUseCaseRepository repository = queryContext.getOrCreateAdminUseCaseRepository();
        ArrayList<UxUseCase> useCases = new ArrayList<UxUseCase>(repository.getUseCases());
        useCases.sort(UxUseCase.MENU_COMPARATOR);
        return useCases;
    }

    public static List<UxUseCase> setupBuilderUseCases(UxQueryContext queryContext, @Nullable UxSchemaId schemaId) {
        UxUseCaseRepository repository = schemaId != null ? queryContext.getOrCreateSchemaBuilderUseCaseRepository(schemaId) : queryContext.getOrCreateBuilderUseCaseRepository();
        ArrayList<UxUseCase> useCases = new ArrayList<UxUseCase>(repository.getUseCases());
        useCases.sort(UxUseCase.MENU_COMPARATOR);
        return useCases;
    }

    private static List<UxUseCase> setupConsoleUseCases(UxQueryContext queryContext) {
        UxConsoleUseCaseRepository repository = queryContext.getOrCreateConsoleUseCaseRepository();
        ArrayList<UxUseCase> useCases = new ArrayList<UxUseCase>(repository.getUseCases());
        useCases.sort(UxUseCase.MENU_COMPARATOR);
        return useCases;
    }

    private UxAppType setupAppType() {
        String info = this.pathInfo;
        if (this.pathInfo == null) {
            info = "";
        }
        OlapLoggers.UX_REQUEST.debug((Object)("[UX] ConsoleInitData(" + info + ")"));
        if (!info.startsWith("/console/ConsoleInitData")) {
            return UxAppType.console;
        }
        if ((info = info.substring("/console/ConsoleInitData".length())).contains("/console/admin")) {
            return UxAppType.admin;
        }
        if (info.contains("/console/builder")) {
            return UxAppType.builder;
        }
        if (info.startsWith("/icCube/console/mdx")) {
            return UxAppType.mdx;
        }
        return UxAppType.console;
    }

    @Nullable
    private UxEnvironment setupEnvironment(UxQueryContext queryContext) {
        OlapTenant tenant;
        IcCubeServerApplicationContext applicationContext = queryContext.getApplicationContext();
        IcCubeServerConfiguration configuration = applicationContext.getConfiguration();
        String envName = configuration.getEnvironmentName();
        if (CdStringUtils.isNullOrBlank((String)envName)) {
            return null;
        }
        String envColor = configuration.getEnvironmentColor();
        String tenantName = null;
        if (queryContext.isWithMultiTenant() && (tenant = queryContext.getUserTenant()) != null) {
            tenantName = tenant.getName();
        }
        return new UxEnvironment(envName, envColor, tenantName);
    }
}

