/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.console.queries.init;

import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.admin.queries.init.UxAdminHomeQueryMeta;
import crazydev.iccube.ux.builder.queries.init.UxBuilderHomeQueryMeta;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionBuilder;
import crazydev.iccube.ux.common.app.UxAppType;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxHomeEntry;
import crazydev.iccube.ux.common.reply.UxHomeReplyPayload;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.url.UxUrlConstants;
import crazydev.iccube.ux.console.UxConsoleQuery;
import crazydev.iccube.ux.console.usecase.UxConsoleUseCaseName;
import crazydev.iccube.ux.dashboards.UxDashboardsHomeQueryMeta;
import crazydev.iccube.ux.help.UxHelpHomeQueryMeta;
import crazydev.iccube.ux.mdx.queries.init.UxMdxConsoleHomeQueryMeta;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class UxConsoleHomeQuery
extends UxConsoleQuery {
    protected UxConsoleHomeQuery(UxQueryMeta meta, OlapRequestId requestId) {
        super(meta, requestId);
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        ArrayList<UxHomeEntry> entries = new ArrayList<UxHomeEntry>();
        this.setupAdmin(queryContext, entries);
        this.setupBuilder(queryContext, entries);
        this.setupMdx(queryContext, entries);
        this.setupDashboards(queryContext, entries);
        this.setupHelp(queryContext, entries);
        return UxReply.success(new UxHomeReplyPayload(UxAppType.console, entries));
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxConsoleUseCaseName.ConsoleHome));
    }

    private void setupAdmin(UxQueryContext context, List<UxHomeEntry> entries) {
        UxAction action = new UxActionBuilder(context, UxAdminHomeQueryMeta.AdminHome).withUrl(UxUrlConstants.APP_URL_ADMIN).withContinuation(UxActionContinuationKind.OPEN_INTERNAL).build();
        if (action == null) {
            return;
        }
        UxBabylonService babylon = context.getUxBabylonService();
        String title = babylon.translate("homeAdmin", new Serializable[0]);
        entries.add(new UxHomeEntry(title, action));
    }

    private void setupBuilder(UxQueryContext context, List<UxHomeEntry> entries) {
        UxAction action = new UxActionBuilder(context, UxBuilderHomeQueryMeta.BuilderHome).withUrl(UxUrlConstants.APP_URL_BUILDER).withContinuation(UxActionContinuationKind.OPEN_INTERNAL).build();
        if (action == null) {
            return;
        }
        UxBabylonService babylon = context.getUxBabylonService();
        String title = babylon.translate("homeBuilder", new Serializable[0]);
        entries.add(new UxHomeEntry(title, action));
    }

    private void setupMdx(UxQueryContext context, List<UxHomeEntry> entries) {
        UxAction action = new UxActionBuilder(context, UxMdxConsoleHomeQueryMeta.MdxConsoleHome).withUrl(UxUrlConstants.APP_URL_MDX).withContinuation(UxActionContinuationKind.OPEN_INTERNAL).build();
        if (action == null) {
            return;
        }
        UxBabylonService babylon = context.getUxBabylonService();
        String title = babylon.translate("homeMdx", new Serializable[0]);
        entries.add(new UxHomeEntry(title, action));
    }

    private void setupDashboards(UxQueryContext context, List<UxHomeEntry> entries) {
        UxAction action = new UxActionBuilder(context, UxDashboardsHomeQueryMeta.DashboardsHome).withUrl(UxUrlConstants.APP_URL_DASHBOARDS).withContinuation(UxActionContinuationKind.OPEN_INTERNAL).build();
        if (action == null) {
            return;
        }
        UxBabylonService babylon = context.getUxBabylonService();
        String title = babylon.translate("homeDashboards", new Serializable[0]);
        entries.add(new UxHomeEntry(title, action));
    }

    private void setupHelp(UxQueryContext context, List<UxHomeEntry> entries) {
        UxAction action = new UxActionBuilder(context, UxHelpHomeQueryMeta.HelpHome).withUrl(UxUrlConstants.APP_URL_HELP).withContinuation(UxActionContinuationKind.OPEN_INTERNAL).build();
        if (action == null) {
            return;
        }
        UxBabylonService babylon = context.getUxBabylonService();
        String title = babylon.translate("homeHelp", new Serializable[0]);
        entries.add(new UxHomeEntry(title, action));
    }
}

