/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.validation;

import crazydev.iccube.ux.UxActionResult;
import crazydev.iccube.ux.UxResultDockName;
import crazydev.iccube.ux.common.validation.UxValidationMessage;
import crazydev.iccube.ux.common.validation.UxValidationSynopsis;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxValidationResult
extends UxActionResult {
    @Nullable
    private UxValidationSynopsis synopsis;
    private final List<UxValidationMessage> messages;

    public UxValidationResult(UxValidationMessage message) {
        this(Collections.singletonList(message));
    }

    public UxValidationResult(List<UxValidationMessage> messages) {
        this.messages = messages;
    }

    public <T> UxValidationResult(List<UxValidationMessage> messages, UxResultDockName dockName) {
        super(dockName);
        this.messages = messages;
    }

    public boolean hasErrors() {
        return this.messages != null && !this.messages.isEmpty();
    }

    public List<UxValidationMessage> getMessages() {
        return this.messages;
    }

    public static UxValidationResult createForClearValidation(UxResultDockName dockName) {
        return new UxValidationResult(Collections.emptyList(), dockName);
    }

    public UxValidationResult withSynopsis(UxValidationSynopsis synopsis) {
        this.synopsis = synopsis;
        return this;
    }

    public UxValidationResult withDockName(UxResultDockName dockName) {
        this.setDockName(dockName);
        return this;
    }
}

