/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.usecase;

import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseRepository;
import crazydev.iccube.ux.builder.UxSchemaBuilderQueryMeta;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxExtraNavigationTree;
import crazydev.iccube.ux.builder.queries.init.UxSchemaBuilderHomeQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.file.UxFileUploadMeta;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseName;
import crazydev.iccube.ux.common.usecase.UxUseCaseTitle;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxUseCaseBuilder {
    private final UxQueryContext context;
    private final UxQueryMeta query;
    @Nullable
    private UxSchemaId schemaId;
    @Nullable
    private String uuid;
    private String id;
    @Nullable
    private String idSuffix;
    @Nullable
    private String parentId;
    @Nullable
    private String extraNavigationKeyId;
    @Nullable
    private String extraNavigationKeyId_;
    private int attrs;
    @Nullable
    private String caption;
    @Nullable
    private String captionTooltip;
    @Nullable
    private String[] group;
    private int orderInGroup = -1;
    @Nullable
    private UxUrl url;
    @Nullable
    private UxUrl bookmark;
    @Nullable
    private UxUseCaseTitle extraTitle;
    @Nullable
    private UxExtraNavigationTree extraNavigation;
    @Nullable
    private List<UxAction> actions;
    @Nullable
    private UxFileUploadMeta fileUpload;
    @Nullable
    private String helpUrl;
    @Nullable
    private String helpTooltip;

    public UxUseCaseBuilder(UxQueryContext context, UxQueryMeta query) {
        this.context = context;
        this.query = query;
        if (query instanceof UxSchemaBuilderQueryMeta) {
            throw new RuntimeException("internal error: use the constructor with UxSchemaBuilderQueryMeta parameter");
        }
    }

    public UxUseCaseBuilder(UxQueryContext context, UxSchemaBuilderQueryMeta query, UxSchemaId schemaId) {
        this.context = context;
        this.query = query;
        this.schemaId = schemaId;
        if (schemaId == null) {
            throw new RuntimeException("internal error: missing UxSchemaId parameter");
        }
        if (query.isHome()) {
            this.caption = schemaId.schemaName;
            this.attrs = 2;
        }
    }

    public UxUseCaseBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public UxUseCaseBuilder withId(UxUseCaseName id) {
        this.id = id.name();
        return this;
    }

    public UxUseCaseBuilder withId(UxUseCaseName id, String suffix) {
        this.id = id.name();
        this.idSuffix = suffix;
        return this;
    }

    public UxUseCaseBuilder withUUID(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public UxUseCaseBuilder withParentId(@Nullable UxUseCaseName id) {
        this.parentId = id != null ? id.name() : null;
        return this;
    }

    public UxUseCaseBuilder withExtraNavigationKeyId(String extraNavigationKeyId) {
        this.extraNavigationKeyId = extraNavigationKeyId;
        return this;
    }

    public UxUseCaseBuilder withExtraNavigationKeyId_(String extraNavigationKeyId_) {
        this.extraNavigationKeyId_ = extraNavigationKeyId_;
        return this;
    }

    public UxUseCaseBuilder withOrderInGroup(int orderInGroup) {
        this.orderInGroup = orderInGroup;
        return this;
    }

    public UxUseCaseBuilder withAttrs(int attrs) {
        this.attrs |= attrs;
        return this;
    }

    public UxUseCaseBuilder withCaption(String caption) {
        this.caption = caption;
        return this;
    }

    public UxUseCaseBuilder withCaptionTooltip(String caption) {
        this.captionTooltip = caption;
        return this;
    }

    public UxUseCaseBuilder withUrl(UxUrl url) {
        this.url = url;
        return this;
    }

    public UxUseCaseBuilder withExtraTitle(UxUseCaseTitle extraTitle) {
        this.extraTitle = extraTitle;
        return this;
    }

    public UxUseCaseBuilder withExtraNavigation(UxExtraNavigationTree extraNavigation) {
        this.extraNavigation = extraNavigation;
        return this;
    }

    public UxUseCaseBuilder withActions(List<UxAction> actions) {
        this.actions = actions;
        return this;
    }

    public UxUseCaseBuilder withActions(UxFileUploadMeta fileUpload) {
        this.fileUpload = fileUpload;
        return this;
    }

    public UxUseCaseBuilder withHelpUrl(String helpUrl) {
        this.helpUrl = helpUrl;
        return this;
    }

    private static String setupGroupOrder(UxBabylonService babylon, String[] path) {
        if (path.length == 0) {
            return "order:-1";
        }
        int order = babylon.translateUseCaseGroupOrder(path[0]);
        return "order:" + order;
    }

    @Nullable
    public UxUseCase build(boolean setupActions) {
        return this.build(true, setupActions);
    }

    @Nullable
    public UxUseCase build(boolean searchable, boolean setupActions) {
        if (!this.query.isAuthorized(this.context)) {
            return null;
        }
        if (this.id == null) {
            throw new RuntimeException("internal error: missing use-case ID");
        }
        UxBabylonService babylon = this.context.getUxBabylonService();
        if (this.caption == null) {
            this.caption = babylon.translateUseCaseCaption(this.id, new Serializable[0]);
        }
        String captionEx = babylon.translateUseCaseCaptionEx(this.id, new Serializable[0]);
        if (this.group == null) {
            String[] path = this.query.getGroup();
            this.group = new String[1 + path.length];
            this.group[0] = UxUseCaseBuilder.setupGroupOrder(babylon, path);
            for (int gg = 0; gg < path.length; ++gg) {
                this.group[1 + gg] = babylon.translateUseCaseGroup(path[gg]);
            }
        }
        if (this.url == null) {
            this.url = this.query instanceof UxSchemaBuilderQueryMeta ? ((UxSchemaBuilderQueryMeta)this.query).createQueryUrl(this.schemaId) : this.query.createQueryUrl();
        }
        UxUrl bookmarkH = null;
        if (this.bookmark == null) {
            this.bookmark = UxAdminUseCaseRepository.asBookmark(this.url);
            if (this.schemaId != null && this.schemaId.schemaName != null) {
                bookmarkH = UxAdminUseCaseRepository.asBookmark(UxSchemaBuilderHomeQueryMeta.BuilderHomeS.createQueryUrl(this.schemaId));
            }
        }
        if (this.extraTitle == null) {
            // empty if block
        }
        if (setupActions && this.actions == null) {
            if (this.query instanceof UxSchemaBuilderQueryMeta) {
                try {
                    this.actions = ((UxSchemaBuilderQueryMeta)this.query).createActions(this.context, this.schemaId);
                }
                catch (UxBuilderSchemaServiceException ex) {
                    OlapLoggers.UX_REQUEST_BUILDER.error((Object)("[ux.builder] could not setup the actions for use-case [" + this.id + "]"), (Throwable)ex);
                }
            } else {
                this.actions = this.query.createActions(this.context);
            }
        }
        if (this.fileUpload == null) {
            this.fileUpload = this.query.createFileUpload(this.context);
        }
        if (this.helpUrl == null) {
            UxUrl helpUrl_ = this.query.helpUrl();
            String string = this.helpUrl = helpUrl_ != null ? helpUrl_.toUrl() : null;
        }
        if (this.helpTooltip == null) {
            this.helpTooltip = babylon.translateUseCaseCaptionHelpTooltip(this.id);
        }
        if (this.query.isHome()) {
            this.attrs |= 1;
        } else if (this.query.isWithExtraNavigation()) {
            this.attrs |= 4;
        }
        return new UxUseCase(this.query, this.uuid, this.id + (String)(this.idSuffix != null ? "-" + this.idSuffix : ""), this.parentId, this.extraNavigationKeyId, this.extraNavigationKeyId_, this.schemaId != null ? this.schemaId.schemaName : null, this.attrs, this.caption, captionEx, this.captionTooltip, this.group, this.orderInGroup, this.url, this.bookmark, bookmarkH, this.extraTitle, this.extraNavigation, this.actions, this.fileUpload, this.helpUrl, this.helpTooltip, searchable);
    }
}

