/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.type;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class UxMap<K, V>
extends HashMap<K, V> {
    public UxMap() {
    }

    public UxMap(List<V> values, Function<V, K> valueToKey) {
        super(values.size());
        values.forEach((? super T t) -> this.put(valueToKey.apply(t), t));
    }

    public static class Deserializer
    implements JsonDeserializer<UxMap> {
        public UxMap deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            throw new RuntimeException("UxMap::deserialize() not supported yes");
        }
    }

    public static class Serializer
    implements JsonSerializer<UxMap> {
        public JsonElement serialize(UxMap src, Type typeOfSrc, JsonSerializationContext context) {
            JsonArray array = new JsonArray();
            Set entries = src.entrySet();
            for (Map.Entry entry : entries) {
                JsonArray eArray = new JsonArray();
                eArray.add(context.serialize(entry.getKey()));
                eArray.add(context.serialize(entry.getValue()));
                array.add((JsonElement)eArray);
            }
            JsonObject obj = new JsonObject();
            obj.addProperty("ic3_Type", "map");
            obj.add("ic3_Value", (JsonElement)array);
            return obj;
        }
    }
}

