/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.table;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.ux.UxSerializable;
import crazydev.iccube.ux.common.filter.UxFilterValue;
import crazydev.iccube.ux.common.reply.UxApi;
import crazydev.iccube.ux.common.table.UxTableSortType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxTableOptions
implements UxSerializable {
    public static final int REST_DEFAULT_PAGE_SIZE = 250;
    public static int UX_DEFAULT_PAGE_SIZE = 10;
    public static List<Integer> UX_DEFAULT_PAGE_SIZES = Arrays.asList(5, 10, 20, 30, 40, 50);
    @Nullable
    private final String orderBy;
    @Nullable
    private final UxTableSortType order;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer pageSize;
    @Nullable
    private final Integer pageTotal;
    @Nullable
    private final String searchText;
    @Nullable
    private final List<UxFilterValue> filter;

    private UxTableOptions(@Nullable String orderBy, @Nullable UxTableSortType order, @Nullable Integer page, @Nullable Integer pageSize, @Nullable Integer pageTotal, @Nullable String searchText, @Nullable List<UxFilterValue> filters) {
        this.searchText = searchText;
        this.orderBy = orderBy;
        this.order = order;
        this.page = page;
        this.pageSize = pageSize;
        this.pageTotal = pageTotal;
        if (filters != null && !filters.isEmpty()) {
            ArrayList<UxFilterValue> filters_ = new ArrayList<UxFilterValue>();
            for (UxFilterValue filter : filters) {
                if (filter == null) continue;
                filters_.add(filter);
            }
            this.filter = !filters.isEmpty() ? filters_ : null;
        } else {
            this.filter = null;
        }
    }

    public static UxTableOptions create() {
        return UxTableOptions.create(null, null);
    }

    public static UxTableOptions create(@Nullable String orderBy, @Nullable UxTableSortType order) {
        return UxTableOptions.create(orderBy, order, null, null, null);
    }

    public static UxTableOptions createForFirstPageWithDefaults(UxApi api, @Nullable Integer pageTotal) {
        int pageSize = api == UxApi.REST ? 250 : UX_DEFAULT_PAGE_SIZE;
        return UxTableOptions.create(null, null, 0, pageSize, pageTotal);
    }

    public static UxTableOptions createForFirstPageWithDefaults(UxApi api, @Nullable String orderBy, @Nullable UxTableSortType order, @Nullable Integer pageTotal) {
        int pageSize = api == UxApi.REST ? 250 : UX_DEFAULT_PAGE_SIZE;
        return UxTableOptions.create(orderBy, order, 0, pageSize, pageTotal);
    }

    public static UxTableOptions create(@Nullable Integer page, @Nullable Integer pageSize, @Nullable Integer pageTotal) {
        return UxTableOptions.create(null, null, page, pageSize, pageTotal);
    }

    public static UxTableOptions create(@Nullable String orderBy, @Nullable UxTableSortType order, @Nullable Integer page, @Nullable Integer pageSize, @Nullable Integer pageTotal) {
        return UxTableOptions.create(orderBy, order, page, pageSize, pageTotal, null);
    }

    public static UxTableOptions create(@Nullable String orderBy, @Nullable UxTableSortType order, @Nullable Integer page, @Nullable Integer pageSize, @Nullable Integer pageTotal, @Nullable List<UxFilterValue> filters) {
        return new UxTableOptions(orderBy, order, page, pageSize, pageTotal, null, filters);
    }

    public static UxTableOptions create(@Nullable String orderBy, @Nullable UxTableSortType order, @Nullable Integer page, @Nullable Integer pageSize, @Nullable Integer pageTotal, @Nullable String searchText, @Nullable List<UxFilterValue> filters) {
        return new UxTableOptions(orderBy, order, page, pageSize, pageTotal, searchText, filters);
    }

    public static UxTableOptions extendWithMissings(@Nullable UxTableOptions target, @Nullable UxTableOptions source) {
        List<UxFilterValue> filters;
        List<UxFilterValue> sFilters;
        if (target == null) {
            return source;
        }
        String orderBy = target.getOrderByX(source != null ? source.getOrderBy() : null);
        UxTableSortType order = target.getOrderX(source != null ? source.getOrder() : null);
        Integer page = target.getPageX(source != null ? source.getPage() : null);
        Integer pageSize = target.getPageSizeX(source != null ? source.getPageSize() : null);
        Integer pageTotal = target.getPageTotalX(source != null ? source.getPageTotal() : null);
        String searchText = target.getSearchTextX(source != null ? source.getSearchText() : null);
        List<UxFilterValue> tFilters = target.filter;
        List<UxFilterValue> list = sFilters = source != null ? source.filter : null;
        if (tFilters == null && sFilters == null) {
            filters = null;
        } else if (tFilters == null) {
            filters = sFilters;
        } else if (sFilters == null) {
            filters = tFilters;
        } else {
            HashSet<String> existing = new HashSet<String>();
            filters = new ArrayList<UxFilterValue>();
            for (UxFilterValue tFilter : tFilters) {
                if (existing.contains(tFilter.getName())) continue;
                existing.add(tFilter.getName());
                filters.add(tFilter);
            }
            for (UxFilterValue sFilter : sFilters) {
                if (existing.contains(sFilter.getName())) continue;
                existing.add(sFilter.getName());
                filters.add(sFilter);
            }
        }
        return UxTableOptions.create(orderBy, order, page, pageSize, pageTotal, searchText, filters);
    }

    @Nullable
    public String getOrderBy() {
        return this.orderBy;
    }

    @Nullable
    public String getOrderByX(@Nullable String defaultValue) {
        return CdStringUtils.isNotNullAndNotBlank((String)this.orderBy) ? this.orderBy : defaultValue;
    }

    @Nullable
    public UxTableSortType getOrder() {
        return this.order;
    }

    @Nullable
    public UxTableSortType getOrderX(@Nullable UxTableSortType defaultValue) {
        return this.order != null ? this.order : defaultValue;
    }

    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Nullable
    public Integer getPageX(@Nullable Integer defaultValue) {
        return this.page != null ? this.page : defaultValue;
    }

    @Nullable
    public Integer getPageSize() {
        return this.pageSize;
    }

    @Nullable
    public Integer getPageSizeX(@Nullable Integer defaultValue) {
        return this.pageSize != null ? this.pageSize : defaultValue;
    }

    @Nullable
    public Integer getPageTotal() {
        return this.pageTotal;
    }

    @Nullable
    public Integer getPageTotalX(@Nullable Integer defaultValue) {
        return this.pageTotal != null ? this.pageTotal : defaultValue;
    }

    @Nullable
    public String getSearchText() {
        return this.searchText;
    }

    @Nullable
    public String getSearchTextX(@Nullable String defaultValue) {
        return CdStringUtils.isNotNullAndNotBlank((String)this.searchText) ? this.searchText : defaultValue;
    }

    @Nullable
    public List<UxFilterValue> getFilter() {
        return this.filter;
    }
}

