/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.table;

import com.opencsv.CSVWriter;
import crazydev.common.fs.CdVFileSystem;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.ux.UxActionResult;
import crazydev.iccube.ux.admin.queries.utils.UxFileWrapper;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeader;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableSortType;
import crazydev.iccube.ux.common.table.raw.UxRestTable;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxTable
extends UxActionResult {
    @Nullable
    private final UxTableOptions options;
    @Nullable
    private final UxTableHeaders header;
    private final List<UxTableRow> rows;
    @Nullable
    private final List<UxAction> multiSelectionActions;

    private UxTable(@Nullable UxTableOptions options, @Nullable UxTableHeaders header, List<UxTableRow> rows, @Nullable List<UxAction> multiSelectionActions) {
        this.options = options;
        this.header = header;
        this.rows = rows;
        this.multiSelectionActions = multiSelectionActions;
    }

    public List<UxTableRow> getRows() {
        return this.rows;
    }

    public UxRestTable toRestFormat() {
        return UxRestTable.create(this.options, this.header, this.rows);
    }

    public UxFileWrapper asFileWrapper(UxQueryContext context) {
        UxBabylonService babylon = context.getUxBabylonService();
        try {
            OlapDirectoriesResolved directories = context.getResolvedDirectories();
            CdVFileSystem vfs = directories.getVfs();
            File file = vfs.createTmpFileForDownload(directories.getTmpDirectory(), "csv");
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
            CSVWriter csv = new CSVWriter((Writer)new BufferedWriter(writer));
            if (this.header != null) {
                UxTableHeader[] headers = this.header.getHeaders();
                String[] line = new String[headers.length];
                for (int ii = 0; ii < line.length; ++ii) {
                    line[ii] = babylon.translate(((UxTableHeader)headers[ii]).getName(), new Serializable[0]);
                }
                csv.writeNext(line);
            }
            for (UxTableRow row : this.rows) {
                List<UxTableCell> cells = row.getCells();
                String[] line = new String[cells.size()];
                for (int ii = 0; ii < line.length; ++ii) {
                    UxTableCell cell = cells.get(ii);
                    Object value = cell.getValue();
                    if (value == null) continue;
                    line[ii] = value.toString();
                }
                csv.writeNext(line);
            }
            csv.flush();
            csv.close();
            OlapFileSystem fs = OlapFileSystem.createFileSystem((CdVFileSystem)directories.getVfs(), (File)file.getParentFile());
            OlapFile file_ = fs.create(file.getName());
            return UxFileWrapper.forOlapFile(file_, file.getName(), "text/csv", true);
        }
        catch (IOException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] IO error while generating the CSV file", (Throwable)ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static UxTable empty() {
        return UxTable.create(new ArrayList<UxTableRow>());
    }

    public static UxTable create(List<UxTableRow> rows) {
        return UxTable.create(null, null, rows);
    }

    public static UxTable create(@Nullable UxTableHeaders header, List<UxTableRow> rows) {
        return UxTable.create(null, header, rows);
    }

    public static UxTable create(@Nullable UxTableOptions options, @Nullable UxTableHeaders header, List<UxTableRow> rows) {
        return UxTable.create(options, header, rows, null);
    }

    public static UxTable create(@Nullable UxTableOptions options, @Nullable UxTableHeaders header, List<UxTableRow> rows, @Nullable List<UxAction> multiSelectionActions) {
        List<UxTableRow> sortedRows = UxTable.sortRows(options, header, rows);
        List<UxTableRow> paginatedRows = UxTable.paginateRows(options, header, sortedRows);
        return new UxTable(options, header, paginatedRows, multiSelectionActions);
    }

    private static List<UxTableRow> sortRows(@Nullable UxTableOptions options, @Nullable UxTableHeaders header, List<UxTableRow> rows) {
        if (header == null || options == null) {
            return rows;
        }
        String orderBy = options.getOrderBy();
        if (CdStringUtils.isNullOrBlank((String)orderBy)) {
            return rows;
        }
        UxTableSortType order = options.getOrderX(UxTableSortType.asc);
        int col = header.getHeaderIndex(orderBy);
        return col < 0 ? rows : UxTable.sort(rows, order, col);
    }

    private static List<UxTableRow> paginateRows(@Nullable UxTableOptions options, @Nullable UxTableHeaders header, List<UxTableRow> rows) {
        if (options == null) {
            return rows;
        }
        Integer page = options.getPage();
        Integer pageSize = options.getPageSize();
        if (page == null || pageSize == null) {
            return rows;
        }
        int from = page * pageSize;
        int to = from + pageSize;
        ArrayList<UxTableRow> paginatedRows = new ArrayList<UxTableRow>();
        for (int rowNumber = from; rowNumber < to && rowNumber < rows.size(); ++rowNumber) {
            paginatedRows.add(rows.get(rowNumber));
        }
        return paginatedRows;
    }

    public static List<UxTableRow> sort(List<UxTableRow> rows, UxTableSortType order, int col) {
        rows.sort((row1, row2) -> {
            List<UxTableCell> cells1 = row1.getCells();
            List<UxTableCell> cells2 = row2.getCells();
            UxTableCell cell1 = col < cells1.size() ? cells1.get(col) : null;
            UxTableCell cell2 = col < cells2.size() ? cells2.get(col) : null;
            int cmp = UxTableCell.compare(cell1, cell2);
            return order == UxTableSortType.asc ? cmp : -cmp;
        });
        return rows;
    }
}

