/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.style;

import crazydev.iccube.ux.UxSerializable;
import crazydev.iccube.ux.common.style.UxStyleLevel;
import crazydev.iccube.ux.common.style.UxStylePresentation;
import org.jetbrains.annotations.Nullable;

public class UxStyle
implements UxSerializable {
    private final UxStyleLevel level;
    private final UxStylePresentation presentation;

    public UxStyle(UxStyleLevel level) {
        this(level, UxStylePresentation.NONE);
    }

    public UxStyle(UxStylePresentation presentation) {
        this(UxStyleLevel.INFO, presentation);
    }

    public UxStyle(UxStyleLevel level, UxStylePresentation presentation) {
        this.level = level;
        this.presentation = presentation;
    }

    public boolean isOnError() {
        return this.level == UxStyleLevel.ERROR;
    }

    public static UxStyle override(@Nullable UxStyle style, UxStyleLevel level) {
        if (style == null) {
            return new UxStyle(level);
        }
        return new UxStyle(level, style.presentation);
    }

    public static UxStyle override(@Nullable UxStyle style, UxStylePresentation presentation) {
        if (style == null) {
            return new UxStyle(presentation);
        }
        return new UxStyle(style.level, presentation);
    }
}

