/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.reply;

import crazydev.iccube.ux.common.reply.UxApi;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.processor.UxBabylonService;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.http.Header;

public class UxContentReply
extends UxReply {
    private final String contentType;
    private final byte[] content;
    private final Header[] headers;

    public UxContentReply(String contentType, byte[] content, Header ... headers) {
        this.contentType = contentType;
        this.content = content;
        this.headers = headers;
    }

    @Override
    public void writeResponse(UxBabylonService babylon, HttpServletRequest request, HttpServletResponse response, UxApi api) throws IOException {
        response.setHeader("Content-Type", this.contentType);
        response.setHeader("Content-Length", "" + this.content.length);
        if (this.headers != null) {
            for (Header header : this.headers) {
                response.addHeader(header.getName(), header.getValue());
            }
        }
        ServletOutputStream out = response.getOutputStream();
        out.write(this.content);
        out.flush();
    }
}

