/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.reply;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.ux.admin.queries.utils.UxFileWrapper;
import crazydev.iccube.ux.common.reply.UxApi;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.processor.UxBabylonService;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class UxAttachmentReply
extends UxReply {
    private final UxFileWrapper file;
    @Nullable
    private final String specifiedAttachmentName;

    public UxAttachmentReply(UxFileWrapper file, @Nullable String attachmentName) {
        this.file = file;
        this.specifiedAttachmentName = attachmentName;
    }

    @Override
    public void writeResponse(UxBabylonService babylon, HttpServletRequest request, HttpServletResponse response, UxApi api) throws IOException {
        this.writeHeaders(request, response);
        this.writeFile(response);
    }

    protected void writeHeaders(HttpServletRequest request, HttpServletResponse response) {
        String ua;
        boolean isIE;
        String attachmentName;
        String mimeType = this.file.getMimeType();
        long length = this.file.length();
        String string = attachmentName = CdStringUtils.isNotNullAndNotBlank((String)this.specifiedAttachmentName) ? this.specifiedAttachmentName : this.file.getName();
        if (attachmentName.endsWith(".log.gz") && "text/plain".equals(mimeType)) {
            attachmentName = attachmentName.substring(0, attachmentName.length() - 3);
        }
        boolean bl = isIE = (ua = request.getHeader("User-Agent").toLowerCase()).contains("msie 6.0") || ua.contains("msie 7.0");
        if (isIE) {
            response.addHeader("Connection", "close");
            response.setContentType("application/force-download; name=\"" + attachmentName + "\"");
        } else {
            response.setHeader("Content-Type", mimeType);
            if (length > -1L) {
                response.setHeader("Content-Length", "" + length);
            }
        }
        response.setHeader("Content-Disposition", "attachment; filename=\"" + attachmentName + "\"");
        response.addHeader("Cache-Control", "no-cache");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFile(HttpServletResponse response) throws IOException {
        ServletOutputStream out = response.getOutputStream();
        InputStream in = this.file.createInputStream();
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.flush();
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            if (this.file.deleteOnExit()) {
                try {
                    this.file.delete();
                }
                catch (RuntimeException ex) {
                    OlapLoggers.UX_REQUEST.warn((Object)("[UX] could not delete the file [" + this.file.getAbsolutePath() + "]"), (Throwable)ex);
                }
            }
        }
    }
}

