/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.model;

import crazydev.common.property.CdProperty;
import crazydev.iccube.ux.common.field.UxField;
import crazydev.iccube.ux.common.field.UxFieldType;
import crazydev.iccube.ux.common.model.UxModelPropertyAccessorListener;
import crazydev.iccube.ux.common.model.UxModelPropertyGroup;
import org.jetbrains.annotations.Nullable;

public class UxModelProperty {
    private final CdProperty serverProperty;
    private final int declarationOrder;
    private final UxModelPropertyGroup uxGroup;
    private final UxField uxProperty;

    public UxModelProperty(CdProperty serverProperty, int declarationOrder, @Nullable UxModelPropertyGroup uxGroup, UxField uxProperty) {
        this.serverProperty = serverProperty;
        this.declarationOrder = declarationOrder;
        this.uxGroup = uxGroup;
        this.uxProperty = uxProperty;
    }

    public boolean isMandatory() {
        return this.uxProperty.isMandatory();
    }

    public int getDeclarationOrder() {
        return this.declarationOrder;
    }

    public UxModelPropertyGroup getGroup() {
        return this.uxGroup;
    }

    public String getName() {
        return this.serverProperty.getName();
    }

    public CdProperty getServerProperty() {
        return this.serverProperty;
    }

    public Class<?> getServerType() {
        return this.serverProperty.getType();
    }

    public UxField getUxProperty() {
        return this.uxProperty;
    }

    public UxFieldType getUiType() {
        return this.uxProperty.getMeta().getType();
    }

    @Nullable
    public Object getFromServerModel(@Nullable UxModelPropertyAccessorListener listener, Object serverModel) {
        try {
            Object serverValue = this.serverProperty.getForUX(serverModel);
            if (listener != null) {
                serverValue = listener.afterGetFromServer(this.serverProperty, serverValue);
            }
            return serverValue;
        }
        catch (Exception ex) {
            throw new RuntimeException("internal error: server-side get property [" + this.serverProperty.getName() + "] error", ex);
        }
    }

    public void setToServerModel(@Nullable UxModelPropertyAccessorListener listener, Object serverModel, @Nullable Object value) {
        if (this.serverProperty.isReadOnly()) {
            return;
        }
        try {
            if (listener != null) {
                value = listener.beforeSetToServer(this.serverProperty, value);
            }
            this.serverProperty.setFromUX(serverModel, value);
        }
        catch (Exception ex) {
            throw new RuntimeException("internal error: server-side get property [" + this.serverProperty.getName() + "] error : " + ex.getMessage(), ex);
        }
    }

    public String toString() {
        return this.serverProperty.getName();
    }
}

