/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.model;

import crazydev.common.property.CdProperty;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.common.OlapBuilderTypeUIXmlIdentifier;
import crazydev.iccube.builder.datasource.facts.OlapBuilderFacts;
import crazydev.iccube.builder.model.def.IOlapBuilderNamedDef;
import crazydev.iccube.builder.model.def.IOlapBuilderObject;
import crazydev.iccube.builder.ux.meta.common.model.UxModelPropertyFilter;
import crazydev.iccube.ux.builder.model.UxBuilderHasRevNumber;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.common.field.UxField;
import crazydev.iccube.ux.common.field.UxFieldType;
import crazydev.iccube.ux.common.field.UxFieldValue;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelProperty;
import crazydev.iccube.ux.common.model.UxModelPropertyGroup;
import crazydev.iccube.ux.common.model.UxModelType;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryExpectedException;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxModelConverter {
    private final UxModelType type;

    public UxModelConverter(UxModelType type) {
        this.type = type;
    }

    public UxModel convertToUxModel(UxQueryContext context, int revNumber, int groupIndex, @Nullable UxBuilderSchemaLock lock, @Nullable Object parentServerModel, Object serverModel, @Nullable UxModelPropertyFilter filter, @Nullable Boolean persistent) {
        ArrayList<UxField> fields = new ArrayList<UxField>();
        List<UxModelProperty> properties = this.type.getProperties();
        for (UxModelProperty property : properties) {
            if (filter != null && !filter.isAcceptingProperty(property.getServerProperty())) continue;
            Object serverValue = property.getFromServerModel(context.getPropertyAccessorListener(), serverModel);
            Object uiValue = this.convertToUiModelValue(context, lock, parentServerModel, serverModel, property, serverValue);
            UxModelPropertyGroup group = filter == null || filter.useGroups() ? property.getGroup() : null;
            fields.add(property.getUxProperty().withGroup(group).withValue(uiValue));
        }
        return new UxModel(this.type.getPersistentId(), revNumber, groupIndex, fields, persistent);
    }

    public UxModel convertToUxModel(UxQueryContext context, int revNumber, @Nullable UxBuilderSchemaLock lock, @Nullable Object parentServerModel, Object serverModel, @Nullable Boolean persistent) {
        return this.convertToUxModel(context, revNumber, 0, lock, parentServerModel, serverModel, null, persistent);
    }

    public UxModel convertToUxModel(UxQueryContext context, int revNumber, @Nullable Object serverModel) {
        if (serverModel == null) {
            serverModel = this.type.createEmptyServerModel();
        }
        return this.convertToUxModel(context, revNumber, null, null, serverModel, null);
    }

    public <T> T convertToServerModel(UxQueryContext context, UxModel model, @Nullable UxModelPropertyFilter filter) {
        boolean nameFilteredOut = false;
        Object serverModel = this.type.createEmptyServerModel();
        List<UxModelProperty> properties = this.type.getProperties();
        for (UxModelProperty property : properties) {
            if (filter != null && !filter.isAcceptingProperty(property.getServerProperty())) {
                String pName = property.getServerProperty().getName();
                if (!pName.equals("name") && !pName.equals("measureGroupName")) continue;
                nameFilteredOut = true;
                continue;
            }
            UxField uiField = model.getField(property.getName());
            if (uiField == null && property.isMandatory()) {
                throw new UxQueryExpectedException(UxErrorCode.CONVERTER_PROP_MISSING, new Serializable[]{property.getName(), this.type.getPersistentId()});
            }
            UxFieldValue uiFieldValue = uiField != null ? uiField.getValue() : null;
            Object uiValue = uiFieldValue != null ? uiFieldValue.getValue() : null;
            Object serverValue = this.convertToServerModelValue(context, property, uiValue);
            property.setToServerModel(context.getPropertyAccessorListener(), serverModel, serverValue);
        }
        if (serverModel instanceof UxBuilderHasRevNumber) {
            ((UxBuilderHasRevNumber)serverModel).setRevNumber(model.getRevNumber());
        }
        if (serverModel instanceof IOlapBuilderNamedDef && !nameFilteredOut) {
            if (serverModel instanceof OlapBuilderFacts) {
                name = ((OlapBuilderFacts)serverModel).getMeasureGroupName();
                if (CdStringUtils.isNullOrBlank((String)name)) {
                    throw new UxQueryExpectedException(UxErrorCode.CONVERTER_PROP_MISSING, new Serializable[]{"measureGroupName", this.type.getPersistentId()});
                }
            } else {
                name = ((IOlapBuilderNamedDef)serverModel).getName();
                if (CdStringUtils.isNullOrBlank((String)name)) {
                    throw new UxQueryExpectedException(UxErrorCode.CONVERTER_PROP_MISSING, new Serializable[]{"name", this.type.getPersistentId()});
                }
            }
        }
        return (T)serverModel;
    }

    public <T> T convertToServerModel(UxQueryContext context, UxModel model) {
        return this.convertToServerModel(context, model, null);
    }

    public <T> void update(T existingBean, T bean) {
        List<UxModelProperty> properties = this.type.getProperties();
        for (UxModelProperty property : properties) {
            Object val = property.getFromServerModel(null, bean);
            property.setToServerModel(null, existingBean, val);
        }
        if (existingBean instanceof UxBuilderHasRevNumber) {
            UxBuilderHasRevNumber existingRevNumber = (UxBuilderHasRevNumber)existingBean;
            UxBuilderHasRevNumber revNumber = (UxBuilderHasRevNumber)bean;
            existingRevNumber.setRevNumber(revNumber.getRevNumber());
        }
        if (existingBean instanceof IOlapBuilderObject) {
            ((IOlapBuilderObject)existingBean).onUpdated();
        }
    }

    @Nullable
    private Object convertToUiModelValue(UxQueryContext context, @Nullable UxBuilderSchemaLock lock, @Nullable Object parentServerModel, Object serverModel, UxModelProperty property, Object serverValue) {
        CdProperty serverProperty = property.getServerProperty();
        Class editorType = serverProperty.getTypeForDefaultEditor();
        if (OlapBuilderTypeUIXmlIdentifier.class.isAssignableFrom(editorType)) {
            return context.getOlapBabylonService().translateUiModelTypeLabel(serverModel.getClass().getName());
        }
        UxFieldType uiType = property.getUiType();
        Object uiValue = uiType.convertToUiModelValue(context, lock, parentServerModel, serverModel, property, serverValue);
        return uiValue;
    }

    @Nullable
    private Object convertToServerModelValue(UxQueryContext context, UxModelProperty property, @Nullable Object uiValue) {
        UxFieldType uiType = property.getUiType();
        Object serverValue = uiType.convertToServerModelValue(context, property, uiValue);
        return serverValue;
    }
}

