/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.json;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class UxJsonParserUtils {
    private UxJsonParserUtils() {
    }

    @Nullable
    public static Map<?, ?> parseAsMap(Object json, String name) {
        String[] path = UxJsonParserUtils.asPath(name);
        Map<?, ?> fields = UxJsonParserUtils.extractMap(json, path);
        if (fields == null) {
            return null;
        }
        Object value = fields.get(UxJsonParserUtils.last(path));
        if (value == null) {
            return null;
        }
        return UxJsonParserUtils.asMap(value);
    }

    @Nullable
    public static List<?> parseAsArray(Object json, String name) {
        String[] path = UxJsonParserUtils.asPath(name);
        Map<?, ?> fields = UxJsonParserUtils.extractMap(json, path);
        if (fields == null) {
            return null;
        }
        Object value = fields.get(UxJsonParserUtils.last(path));
        if (value == null) {
            return null;
        }
        return UxJsonParserUtils.asArray(value);
    }

    public static List<String> parseAsArrayOfString(Map<?, ?> jFields, String name) {
        List<?> values = UxJsonParserUtils.parseAsArray(jFields, name);
        ArrayList<String> strings = new ArrayList<String>();
        if (values != null) {
            for (Object value : values) {
                if (value == null) continue;
                strings.add(String.valueOf(value));
            }
        }
        return strings;
    }

    @Nullable
    public static String parseAsString(Object json, String name) {
        String[] path = UxJsonParserUtils.asPath(name);
        Map<?, ?> fields = UxJsonParserUtils.extractMap(json, path);
        if (fields == null) {
            return null;
        }
        Object value = fields.get(UxJsonParserUtils.last(path));
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    public static boolean parseAsBoolean(Object json, String name) {
        String[] path = UxJsonParserUtils.asPath(name);
        Map<?, ?> fields = UxJsonParserUtils.extractMap(json, path);
        if (fields == null) {
            return false;
        }
        Object value = fields.get(UxJsonParserUtils.last(path));
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(String.valueOf(value));
    }

    @Nullable
    private static Map<?, ?> extractMap(Object json, String[] path) {
        if (json == null) {
            return null;
        }
        Map<?, ?> fields = UxJsonParserUtils.asMap(json);
        for (int ii = 0; ii < path.length - 1; ++ii) {
            Object field = fields.get(path[ii]);
            if (field == null) {
                return null;
            }
            fields = UxJsonParserUtils.asMap(field);
        }
        return fields;
    }

    private static Map<?, ?> asMap(Object json) {
        if (json instanceof Map) {
            return (Map)json;
        }
        throw new RuntimeException("JSON: field type mismatch (expected: map) (actual: " + (json != null ? json.getClass().getName() : "<null>"));
    }

    private static List<?> asArray(Object json) {
        if (json instanceof List) {
            return (List)json;
        }
        throw new RuntimeException("JSON: field type mismatch (expected: list) (actual: " + (json != null ? json.getClass().getName() : "<null>"));
    }

    private static String[] asPath(String name) {
        return name.split("\\.");
    }

    private static String last(String[] path) {
        return path[path.length - 1];
    }
}

