/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.filter;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.ux.UxSerializable;
import crazydev.iccube.ux.common.filter.UxFilterKind;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import java.io.Serializable;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class UxFilterValue
implements UxSerializable {
    private final String name;
    private final UxFilterKind kind;
    private final String[] value;

    protected UxFilterValue(String name, UxFilterKind kind, String[] value) {
        this.name = name;
        this.kind = kind;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String[] getValue() {
        return this.value;
    }

    @Nullable
    public static UxFilterValue create(String value) throws UxQueryParserException {
        String[] parts;
        if (CdStringUtils.isNotNullAndNotBlank((String)value) && (parts = value.split("\\|")).length > 2) {
            UxFilterKind kind;
            String kind_ = parts[1];
            try {
                kind = UxFilterKind.valueOf(kind_);
            }
            catch (RuntimeException ex) {
                throw new UxQueryParserException(UxErrorCode.PARAM_UNEXPECTED_VALUE, new Serializable[]{"filter.kind", kind_});
            }
            return new UxFilterValue(parts[0], kind, Arrays.copyOfRange(parts, 2, parts.length));
        }
        return null;
    }

    public boolean isAccepting(@Nullable Object value) {
        return this.kind.isAccepting(this, value);
    }
}

