/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.field;

import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.ux.UxFieldKind;
import crazydev.iccube.ux.common.field.UxFieldType;
import crazydev.iccube.ux.common.model.UxModelProperty;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryExpectedException;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

class UxLongFieldType
extends UxFieldType {
    UxLongFieldType() {
        super(UxFieldKind.LONG);
    }

    @Override
    public Object convertToServerModelValue(UxQueryContext context, UxModelProperty property, @Nullable Object uiValue) {
        if (uiValue == null) {
            return null;
        }
        if (uiValue instanceof Number) {
            return ((Number)uiValue).longValue();
        }
        if (uiValue instanceof String) {
            try {
                return Long.valueOf((String)uiValue);
            }
            catch (IllegalArgumentException ex) {
                OlapLoggers.UX_REQUEST.error((Object)("[UX] long field [" + property.getName() + "] type mismatch : " + String.valueOf(uiValue)), (Throwable)ex);
            }
        }
        throw new UxQueryExpectedException(UxErrorCode.CONVERTER_PROP_TYPE_ERROR, new Serializable[]{property.getName(), String.valueOf(uiValue), "long"});
    }
}

