/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.field;

import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.ux.UxSerializable;
import crazydev.iccube.ux.common.field.UxHelpTextItem;
import crazydev.iccube.ux.common.field.UxHelpTextItemText;
import crazydev.iccube.ux.common.field.UxHelpTextItemUrl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class UxHelpText
implements UxSerializable {
    private static final Pattern PATTERN = Pattern.compile("^(.*)<a[^>]href=\"(.*)\"\\s[^>]+>([^<]+)</a>(.*)$", 32);
    private List<UxHelpTextItem> items;

    public UxHelpText(List<UxHelpTextItem> items) {
        this.items = items;
    }

    public List<UxHelpTextItem> getItems() {
        return this.items;
    }

    @Nullable
    public static UxHelpText create(@Nullable String description) {
        if (description == null) {
            return null;
        }
        List<UxHelpTextItem> items = !description.contains("<a") ? Collections.singletonList(new UxHelpTextItemText(description)) : UxHelpText.createFromRegExp(description);
        if (items.isEmpty()) {
            return null;
        }
        return new UxHelpText(items);
    }

    private static List<UxHelpTextItem> createFromRegExp(String input) {
        try {
            Matcher matcher = PATTERN.matcher(input);
            boolean found = matcher.find();
            if (found) {
                String prefix = matcher.group(1);
                String url = matcher.group(2);
                String caption = matcher.group(3);
                String suffix = matcher.group(4);
                ArrayList<UxHelpTextItem> items = new ArrayList<UxHelpTextItem>();
                if (!prefix.isEmpty()) {
                    items.add(new UxHelpTextItemText(prefix));
                }
                items.add(new UxHelpTextItemUrl(url, caption));
                if (!suffix.isEmpty()) {
                    items.add(new UxHelpTextItemText(suffix));
                }
                return items;
            }
            return Collections.singletonList(new UxHelpTextItemText(input));
        }
        catch (RuntimeException ex) {
            OlapLoggers.GENERAL.warn((Object)("could not extract the URL from [" + input + "]"), (Throwable)ex);
            return Collections.singletonList(new UxHelpTextItemText(input));
        }
    }
}

