/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.field;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.ux.UxFieldKind;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.common.field.UxFieldType;
import crazydev.iccube.ux.common.model.UxModelProperty;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryExpectedException;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.type.UxEnumValue;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class UxEnumsFieldType
extends UxFieldType {
    private final transient Class<?> enumType;
    private final UxEnumValue[] values;

    UxEnumsFieldType(Class<?> enumType, UxEnumValue[] values) {
        this(UxFieldKind.ENUMS, enumType, values);
    }

    UxEnumsFieldType(UxFieldKind kind, Class<?> enumType, UxEnumValue[] values) {
        super(kind);
        this.enumType = enumType;
        this.values = values;
    }

    public UxEnumValue[] getValues() {
        return this.values;
    }

    @Override
    public Object convertToUiModelValue(UxQueryContext context, @Nullable UxBuilderSchemaLock lock, @Nullable Object parentServerModel, Object serverModel, UxModelProperty property, @Nullable Object serverValue) {
        return serverValue;
    }

    @Override
    public Object convertToServerModelValue(UxQueryContext context, UxModelProperty property, @Nullable Object uiValue) {
        if (uiValue == null || uiValue instanceof String && CdStringUtils.isNullOrBlank((String)((String)uiValue))) {
            return null;
        }
        if (this.enumType.isEnum() && uiValue instanceof List) {
            List value = (List)uiValue;
            List<Object> output = value.stream().map(uiSingle -> Enum.valueOf(this.enumType, (String)uiSingle)).collect(Collectors.toList());
            if (property.getServerType().isArray()) {
                if (output.isEmpty()) {
                    return null;
                }
                return output.toArray((Object[])Array.newInstance(property.getServerType().getComponentType(), output.size()));
            }
            return output;
        }
        throw new UxQueryExpectedException(UxErrorCode.CONVERTER_PROP_TYPE_ERROR, new Serializable[]{property.getName(), String.valueOf(uiValue), "enum"});
    }
}

