/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.field;

import crazydev.common.utils.CdEnumerableForUi;
import crazydev.common.utils.CdLocaleUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.ux.UxEnumFieldKind;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.common.field.UxFieldType;
import crazydev.iccube.ux.common.model.UxModelProperty;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryExpectedException;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.type.UxEnumValue;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class UxEnumFieldType
extends UxFieldType {
    private final transient Class<?> enumType;
    private final UxEnumValue[] values;

    UxEnumFieldType(UxEnumFieldKind kind, Class<?> enumType, List<UxEnumValue> values) {
        super(kind.toFieldKind());
        this.enumType = enumType;
        this.values = values.toArray(new UxEnumValue[values.size()]);
    }

    UxEnumFieldType(UxEnumFieldKind kind, Class<?> enumType, UxEnumValue[] values) {
        super(kind.toFieldKind());
        this.enumType = enumType;
        this.values = values;
    }

    public UxEnumValue[] getValues() {
        return this.values;
    }

    @Override
    public Object convertToUiModelValue(UxQueryContext context, @Nullable UxBuilderSchemaLock lock, @Nullable Object parentServerModel, Object serverModel, UxModelProperty property, @Nullable Object serverValue) {
        if (serverValue instanceof CdEnumerableForUi) {
            return ((CdEnumerableForUi)serverValue).getValue();
        }
        return serverValue;
    }

    @Override
    public Object convertToServerModelValue(UxQueryContext context, UxModelProperty property, @Nullable Object uiValue) {
        Locale locale;
        if (uiValue == null || uiValue instanceof String && CdStringUtils.isNullOrBlank((String)((String)uiValue))) {
            return null;
        }
        if (this.enumType.isEnum() && uiValue instanceof String) {
            try {
                return Enum.valueOf(this.enumType, (String)uiValue);
            }
            catch (IllegalArgumentException ex) {
                OlapLoggers.UX_REQUEST.error((Object)("[UX] enum field [" + property.getName() + "] type mismatch : " + String.valueOf(uiValue)), (Throwable)ex);
            }
        }
        if (Locale.class.isAssignableFrom(this.enumType) && uiValue instanceof String && (locale = CdLocaleUtils.fromName((String)((String)uiValue))) != null) {
            return locale;
        }
        if (CdEnumerableForUi.class.isAssignableFrom(this.enumType)) {
            return uiValue;
        }
        if (String.class.isAssignableFrom(this.enumType)) {
            return uiValue;
        }
        throw new UxQueryExpectedException(UxErrorCode.CONVERTER_PROP_TYPE_ERROR, new Serializable[]{property.getName(), String.valueOf(uiValue), "enum"});
    }
}

