/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.field;

import crazydev.iccube.builder.datasource.facts.OlapBuilderFacts;
import crazydev.iccube.builder.datasource.facts.OlapBuilderFactsMappings;
import crazydev.iccube.builder.datasource.facts.OlapBuilderLinkXmlDefinition;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewLinksDef;
import crazydev.iccube.builder.model.def.OlapBuilderDataViewLinksType;
import crazydev.iccube.builder.model.impl.OlapBuilderBridgeRef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumnRef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataViewLinks;
import crazydev.iccube.ux.UxFieldKind;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.builder.queries.facts.mappings.UxFactsDimensionMappingBuilder;
import crazydev.iccube.ux.builder.queries.facts.mappings.UxFactsDimensionMappings;
import crazydev.iccube.ux.common.field.UxFieldType;
import crazydev.iccube.ux.common.json.UxJsonParserUtils;
import crazydev.iccube.ux.common.model.UxModelProperty;
import crazydev.iccube.ux.common.query.UxQueryContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.jetbrains.annotations.Nullable;

class UxDimMappingsFieldType
extends UxFieldType {
    UxDimMappingsFieldType() {
        super(UxFieldKind.DIM_MAPPINGS);
    }

    @Override
    public Object convertToUiModelValue(UxQueryContext context, @Nullable UxBuilderSchemaLock lock, @Nullable Object parentServerModel, Object serverModel, UxModelProperty property, @Nullable Object serverValue) {
        UxFactsDimensionMappingBuilder builder = new UxFactsDimensionMappingBuilder(context, lock, (UxBuilderSchema)parentServerModel, (OlapBuilderFacts)serverModel, (OlapBuilderFactsMappings)serverValue);
        UxFactsDimensionMappings uiValue = builder.build();
        return uiValue;
    }

    @Override
    public Object convertToServerModelValue(UxQueryContext context, UxModelProperty property, @Nullable Object uiValue) {
        if (uiValue == null) {
            return new OlapBuilderFactsMappings(new ArrayList());
        }
        if (uiValue instanceof UxFactsDimensionMappings) {
            List<OlapBuilderLinkXmlDefinition> links = this.setupLinks((UxFactsDimensionMappings)uiValue);
            return new OlapBuilderFactsMappings(links);
        }
        return uiValue;
    }

    private List<OlapBuilderLinkXmlDefinition> setupLinks(UxFactsDimensionMappings mappings) {
        Object json = mappings.getJson();
        List<?> jMappings = UxJsonParserUtils.parseAsArray(json, "mappings");
        if (jMappings == null) {
            return new ArrayList<OlapBuilderLinkXmlDefinition>();
        }
        ArrayList<OlapBuilderLinkXmlDefinition> links = new ArrayList<OlapBuilderLinkXmlDefinition>();
        for (Object jMapping : jMappings) {
            OlapBuilderLinkXmlDefinition link = this.setupLink(jMapping);
            if (link == null) continue;
            links.add(link);
        }
        return links;
    }

    private OlapBuilderLinkXmlDefinition setupLink(Object jMapping) {
        String dimensionId = UxJsonParserUtils.parseAsString(jMapping, "dimensionId");
        String dimensionName = UxJsonParserUtils.parseAsString(jMapping, "dimensionName");
        String type_ = UxJsonParserUtils.parseAsString(jMapping, "type.value.value");
        OlapBuilderDataViewLinksType type = OlapBuilderDataViewLinksType.valueOf((String)type_);
        Map<?, ?> jFields = UxJsonParserUtils.parseAsMap(jMapping, "models." + type_);
        return switch (type) {
            case OlapBuilderDataViewLinksType.ON_ERROR -> this.setupLinkOnError(dimensionId, dimensionName, jFields);
            case OlapBuilderDataViewLinksType.NOT_SPECIFIED -> this.setupLinkNotSpecified(dimensionId, dimensionName, jFields);
            case OlapBuilderDataViewLinksType.NOT_MAPPED -> this.setupLinkNotMapped(dimensionId, dimensionName, jFields);
            case OlapBuilderDataViewLinksType.LAST_LEVEL -> this.setupLinkLastLevel(dimensionId, dimensionName, jFields);
            case OlapBuilderDataViewLinksType.ALL_LEVELS -> this.setupLinkAllLevels(dimensionId, dimensionName, jFields);
            case OlapBuilderDataViewLinksType.INTERMEDIATE_LEVEL -> this.setupLinkIntermediateLevel(dimensionId, dimensionName, jFields);
            case OlapBuilderDataViewLinksType.LEVEL_LIST -> this.setupLinkLevelList(dimensionId, dimensionName, jFields);
            case OlapBuilderDataViewLinksType.RANGE_FROM_TO -> this.setupLinkRangeFromTo(dimensionId, dimensionName, jFields);
            default -> throw new OlapBuilderErrorException(OlapBuilderErrorCode.FACT_LINKS_TYPE_MISMATCH, new Serializable[]{dimensionName, type.name()});
        };
    }

    private OlapBuilderLinkXmlDefinition setupLinkOnError(String dimensionId, String dimensionName, Map<?, ?> jFields) {
        throw new OlapBuilderErrorException(OlapBuilderErrorCode.FACT_LINKS_TYPE_ON_ERROR, new Serializable[]{dimensionName});
    }

    private OlapBuilderLinkXmlDefinition setupLinkNotSpecified(String dimensionId, String dimensionName, Map<?, ?> jFields) {
        return new OlapBuilderLinkXmlDefinition(dimensionId, dimensionName, (IOlapBuilderDataViewLinksDef)new OlapBuilderDataViewLinks(OlapBuilderDataViewLinksType.NOT_SPECIFIED));
    }

    private OlapBuilderLinkXmlDefinition setupLinkNotMapped(String dimensionId, String dimensionName, Map<?, ?> jFields) {
        return new OlapBuilderLinkXmlDefinition(dimensionId, dimensionName, (IOlapBuilderDataViewLinksDef)new OlapBuilderDataViewLinks(OlapBuilderDataViewLinksType.NOT_MAPPED));
    }

    private OlapBuilderLinkXmlDefinition setupLinkLastLevel(String dimensionId, String dimensionName, Map<?, ?> jFields) {
        OlapBuilderDataViewLinks link;
        boolean isBridge = UxJsonParserUtils.parseAsBoolean(jFields, "isBridge");
        if (isBridge) {
            List<OlapBuilderBridgeRef> bridge = this.asBridge(jFields, "bridge");
            link = OlapBuilderDataViewLinks.createFromBridge((OlapBuilderDataViewLinksType)OlapBuilderDataViewLinksType.LAST_LEVEL, bridge);
        } else {
            List<String> to = this.asColumnNames(jFields, "selectedFactsColumns");
            List<OlapBuilderDataColumnRef> toColumns = this.asColumnRefs(to);
            link = OlapBuilderDataViewLinks.createFromColumnsRef((OlapBuilderDataViewLinksType)OlapBuilderDataViewLinksType.LAST_LEVEL, new ArrayList(), toColumns);
        }
        return new OlapBuilderLinkXmlDefinition(dimensionId, dimensionName, (IOlapBuilderDataViewLinksDef)link);
    }

    private OlapBuilderLinkXmlDefinition setupLinkAllLevels(String dimensionId, String dimensionName, Map<?, ?> jFields) {
        OlapBuilderDataViewLinks link;
        boolean isBridge = UxJsonParserUtils.parseAsBoolean(jFields, "isBridge");
        if (isBridge) {
            List<OlapBuilderBridgeRef> bridge = this.asBridge(jFields, "bridge");
            link = OlapBuilderDataViewLinks.createFromBridge((OlapBuilderDataViewLinksType)OlapBuilderDataViewLinksType.ALL_LEVELS, bridge);
        } else {
            List<String> to = this.asColumnNames(jFields, "selectedFactsColumns");
            List<OlapBuilderDataColumnRef> toColumns = this.asColumnRefs(to);
            link = OlapBuilderDataViewLinks.createFromColumnsRef((OlapBuilderDataViewLinksType)OlapBuilderDataViewLinksType.ALL_LEVELS, new ArrayList(), toColumns);
        }
        return new OlapBuilderLinkXmlDefinition(dimensionId, dimensionName, (IOlapBuilderDataViewLinksDef)link);
    }

    private OlapBuilderLinkXmlDefinition setupLinkIntermediateLevel(String dimensionId, String dimensionName, Map<?, ?> jFields) {
        OlapBuilderDataViewLinks link;
        List<String> fromLevelNames = this.asLevelName(jFields, "level.value.value");
        boolean isBridge = UxJsonParserUtils.parseAsBoolean(jFields, "isBridge");
        if (isBridge) {
            List<OlapBuilderBridgeRef> bridge = this.asBridge(jFields, "bridge");
            link = OlapBuilderDataViewLinks.createFromBridge((OlapBuilderDataViewLinksType)OlapBuilderDataViewLinksType.INTERMEDIATE_LEVEL, fromLevelNames, bridge);
        } else {
            List<String> to = this.asColumnNames(jFields, "selectedFactsColumns");
            List<OlapBuilderDataColumnRef> toColumns = this.asColumnRefs(to);
            link = OlapBuilderDataViewLinks.createFromLevelNames((OlapBuilderDataViewLinksType)OlapBuilderDataViewLinksType.INTERMEDIATE_LEVEL, fromLevelNames, toColumns);
        }
        return new OlapBuilderLinkXmlDefinition(dimensionId, dimensionName, (IOlapBuilderDataViewLinksDef)link);
    }

    private OlapBuilderLinkXmlDefinition setupLinkLevelList(String dimensionId, String dimensionName, Map<?, ?> jFields) {
        OlapBuilderDataViewLinks link;
        List<String> fromLevelNames = this.asLevelNames(jFields, "levels.value.value");
        boolean isBridge = UxJsonParserUtils.parseAsBoolean(jFields, "isBridge");
        if (isBridge) {
            List<OlapBuilderBridgeRef> bridge = this.asBridge(jFields, "bridge");
            link = OlapBuilderDataViewLinks.createFromBridge((OlapBuilderDataViewLinksType)OlapBuilderDataViewLinksType.LEVEL_LIST, fromLevelNames, bridge);
        } else {
            List<String> to = this.asColumnNames(jFields, "selectedFactsColumns");
            List<OlapBuilderDataColumnRef> toColumns = this.asColumnRefs(to);
            link = OlapBuilderDataViewLinks.createFromLevelNames((OlapBuilderDataViewLinksType)OlapBuilderDataViewLinksType.LEVEL_LIST, fromLevelNames, toColumns);
        }
        return new OlapBuilderLinkXmlDefinition(dimensionId, dimensionName, (IOlapBuilderDataViewLinksDef)link);
    }

    private OlapBuilderLinkXmlDefinition setupLinkRangeFromTo(String dimensionId, String dimensionName, Map<?, ?> jFields) {
        List<String> from = this.asColumnNames(jFields, "selectedFactsColumnsFrom");
        List<String> to = this.asColumnNames(jFields, "selectedFactsColumnsTo");
        List<OlapBuilderDataColumnRef> toColumns = this.asColumnRefs(from, to);
        OlapBuilderDataViewLinks link = OlapBuilderDataViewLinks.createFromColumnsRef((OlapBuilderDataViewLinksType)OlapBuilderDataViewLinksType.RANGE_FROM_TO, new ArrayList(), toColumns);
        return new OlapBuilderLinkXmlDefinition(dimensionId, dimensionName, (IOlapBuilderDataViewLinksDef)link);
    }

    private List<OlapBuilderBridgeRef> asBridge(Map<?, ?> jFields, String name) {
        ArrayList<OlapBuilderBridgeRef> refs = new ArrayList<OlapBuilderBridgeRef>();
        Map<?, ?> jBridge = UxJsonParserUtils.parseAsMap(jFields, "bridge");
        List<?> jBridgeRefs = UxJsonParserUtils.parseAsArray(jBridge, "bridges");
        if (jBridgeRefs != null) {
            for (Object jBridgeRef : jBridgeRefs) {
                Map bridge = (Map)jBridgeRef;
                String uuid = UxJsonParserUtils.parseAsString(bridge, "uuid");
                List<String> joinFactsColumns = this.asColumnNames(bridge, "joinFactsColumns");
                List<String> joinBridgeColumns = this.asColumnNames(bridge, "joinBridgeColumns");
                List<String> keyBridgeColumns = this.asColumnNames(bridge, "keyBridgeColumns");
                boolean one2one = UxJsonParserUtils.parseAsBoolean(bridge, "one2one");
                refs.add(OlapBuilderBridgeRef.createFromUX((String)uuid, this.asColumnRefs(keyBridgeColumns), this.asColumnRefs(joinFactsColumns), this.asColumnRefs(joinBridgeColumns), (boolean)one2one));
            }
        }
        return refs;
    }

    private List<String> asLevelName(Map<?, ?> jFields, String name) {
        ArrayList<String> names = new ArrayList<String>();
        String level = UxJsonParserUtils.parseAsString(jFields, name);
        if (level != null) {
            names.add(level);
        }
        return names;
    }

    private List<String> asLevelNames(Map<?, ?> jFields, String name) {
        List<String> levels = UxJsonParserUtils.parseAsArrayOfString(jFields, name);
        if (levels == null) {
            return new ArrayList<String>();
        }
        return levels;
    }

    private List<String> asColumnNames(Map<?, ?> jFields, String name) {
        List<String> names = UxJsonParserUtils.parseAsArrayOfString(jFields, name);
        if (names == null) {
            return new ArrayList<String>();
        }
        return names;
    }

    private List<OlapBuilderDataColumnRef> asColumnRefs(List<String> names) {
        TreeSet<String> uniqueNames = new TreeSet<String>();
        ArrayList<OlapBuilderDataColumnRef> refs = new ArrayList<OlapBuilderDataColumnRef>();
        if (names != null) {
            for (String name : names) {
                if (uniqueNames.contains(name)) continue;
                refs.add(new OlapBuilderDataColumnRef(name));
                uniqueNames.add(name);
            }
        }
        return refs;
    }

    private List<OlapBuilderDataColumnRef> asColumnRefs(List<String> from, List<String> to) {
        TreeSet<String> uniqueNames = new TreeSet<String>();
        ArrayList<OlapBuilderDataColumnRef> refs = new ArrayList<OlapBuilderDataColumnRef>();
        if (from != null) {
            for (String name : from) {
                if (uniqueNames.contains(name)) continue;
                refs.add(new OlapBuilderDataColumnRef(name));
                uniqueNames.add(name);
            }
        }
        if (to != null) {
            for (String name : to) {
                if (uniqueNames.contains(name)) continue;
                refs.add(new OlapBuilderDataColumnRef(name));
                uniqueNames.add(name);
            }
        }
        return refs;
    }
}

