/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.action;

import crazydev.iccube.ux.common.action.UxAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public abstract class UxActionUtils {
    private UxActionUtils() {
    }

    @Nullable
    public static List<UxAction> addActions(@Nullable List<UxAction> actions, UxAction ... action) {
        if (action == null) {
            return actions;
        }
        if (actions == null) {
            actions = new ArrayList<UxAction>();
        }
        actions.addAll(Arrays.stream(action).filter(Objects::nonNull).collect(Collectors.toList()));
        return actions;
    }

    @Nullable
    public static List<UxAction> removeNulls(@Nullable List<UxAction> actions) {
        if (actions == null) {
            return null;
        }
        boolean hasNull = false;
        for (UxAction action : actions) {
            if (action != null) continue;
            hasNull = true;
            break;
        }
        if (!hasNull) {
            return actions;
        }
        ArrayList<UxAction> actions_ = new ArrayList<UxAction>();
        for (UxAction action : actions) {
            if (action == null) continue;
            actions_.add(action);
        }
        if (actions_.isEmpty()) {
            return null;
        }
        return actions_;
    }
}

