/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.service;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.fs.CdVFileSystem;
import crazydev.common.fs.revision.CdVFileRev;
import crazydev.common.fs.revision.CdVFileRevAction;
import crazydev.common.fs.revision.CdVFileRevActionBookmark;
import crazydev.common.fs.revision.CdVFileRevActionOperation;
import crazydev.common.fs.revision.CdVFileRevFolder;
import crazydev.common.fs.revision.CdVFileRevHelperConf;
import crazydev.common.fs.revision.CdVFileRevManagerKind;
import crazydev.common.xml.CdXmlUtils;
import crazydev.iccube.builder.OlapBuilderMetaInformationRepository;
import crazydev.iccube.builder.factory.schema.OlapBuilderBaseSchemaDefFactory;
import crazydev.iccube.builder.factory.schema.OlapBuilderSchemaDefFactory;
import crazydev.iccube.builder.model.impl.OlapBuilderSchema;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfo;
import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfoError;
import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfoParser;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.model.UxBuilderSchemaLock;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaLockKind;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaRepositoryHelper;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import jakarta.xml.bind.JAXBException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

class UxBuilderSchemaRepository {
    private final CdVFileSystem vfs;
    private final OlapTenant tenant;
    private final String tenantInfo;
    private final File tmpDirectory;
    private final File builderDirectory;
    private final OlapBuilderMetaInformationRepository metaInformation;

    UxBuilderSchemaRepository(OlapDirectoriesResolved directories, OlapBuilderMetaInformationRepository metaInformation) {
        this.vfs = directories != null ? directories.getVfs() : new CdVFileSystem();
        this.tenant = directories != null ? directories.getTenant() : null;
        this.tenantInfo = OlapTenant.info((OlapTenant)this.tenant);
        this.tmpDirectory = directories != null ? directories.getTmpDirectory() : null;
        this.builderDirectory = directories != null ? directories.getBuilderDirectory() : null;
        this.metaInformation = metaInformation;
    }

    public void refreshMetaInformation() {
        this.metaInformation.refreshMetaInformation();
    }

    public CdVFileSystem getVfs() {
        return this.vfs;
    }

    OlapTenant getTenant() {
        return this.tenant;
    }

    String getTenantInfo() {
        return this.tenantInfo;
    }

    File getBuilderDirectory() {
        return this.builderDirectory;
    }

    CdVFileRev getSchemaRevision(UxBuilderSchemaLock lock, UxBuilderSchema definition, String revFileName, boolean withPayload) {
        try {
            OlapBuilderBaseSchemaDefFactory factory = definition.getFactory();
            File xml = factory.getXmlFile();
            if (xml == null) {
                throw new IOException("internal error: missing XML file for schema [" + definition.getName() + "]");
            }
            CdVFileRevHelperConf configuration = new CdVFileRevHelperConf(CdVFileRevManagerKind.SCHEMA_BUILDER, this.tmpDirectory, this.builderDirectory);
            return this.vfs.getRevision(configuration, xml, revFileName, withPayload);
        }
        catch (IOException ex) {
            throw new UxBuilderSchemaServiceException(ex, CdError.create((CdErrorCode)UxErrorCode.ERROR_UNEXPECTED, (Serializable[])new Serializable[]{"could not retrieve schema def. revisions: " + this.fixErrorMessageForBuilderPath(ex)}));
        }
    }

    UxBuilderSchema restoreSchemaRevision(String savedBy, UxBuilderSchemaLock lock, UxBuilderSchema definition, String revFileName) {
        try {
            OlapBuilderBaseSchemaDefFactory factory = definition.getFactory();
            File xml = factory.getXmlFile();
            if (xml == null) {
                throw new IOException("internal error: missing XML file for schema [" + definition.getName() + "]");
            }
            CdVFileRevHelperConf configuration = new CdVFileRevHelperConf(CdVFileRevManagerKind.SCHEMA_BUILDER, this.tmpDirectory, this.builderDirectory);
            this.vfs.restoreRevision(configuration, savedBy, xml, revFileName);
            return this.unmarshallSchemaDefinition(xml);
        }
        catch (IOException ex) {
            throw new UxBuilderSchemaServiceException(ex, CdError.create((CdErrorCode)UxErrorCode.ERROR_UNEXPECTED, (Serializable[])new Serializable[]{"could not restore the schema def. revision: " + this.fixErrorMessageForBuilderPath(ex)}));
        }
    }

    void bookmarkSchemaRevision(UxBuilderSchemaLock lock, UxBuilderSchema definition, String revFileName, String bookmark) {
        try {
            OlapBuilderBaseSchemaDefFactory factory = definition.getFactory();
            File xml = factory.getXmlFile();
            if (xml == null) {
                throw new IOException("internal error: missing XML file for schema [" + definition.getName() + "]");
            }
            CdVFileRevHelperConf configuration = new CdVFileRevHelperConf(CdVFileRevManagerKind.SCHEMA_BUILDER, this.tmpDirectory, this.builderDirectory);
            this.vfs.bookmarkRevision(configuration, xml, revFileName, bookmark);
        }
        catch (IOException ex) {
            throw new UxBuilderSchemaServiceException(ex, CdError.create((CdErrorCode)UxErrorCode.ERROR_UNEXPECTED, (Serializable[])new Serializable[]{"could not bookmark the schema def. revision: " + this.fixErrorMessageForBuilderPath(ex)}));
        }
    }

    void forEachSchemaRevision(UxBuilderSchemaLock lock, UxBuilderSchema definition, Consumer<CdVFileRev> consumer) {
        try {
            OlapBuilderBaseSchemaDefFactory factory = definition.getFactory();
            File xml = factory.getXmlFile();
            if (xml == null) {
                throw new IOException("internal error: missing XML file for schema [" + definition.getName() + "]");
            }
            CdVFileRevHelperConf configuration = new CdVFileRevHelperConf(CdVFileRevManagerKind.SCHEMA_BUILDER, this.tmpDirectory, this.builderDirectory);
            this.vfs.forEachRevisions(configuration, xml, consumer);
        }
        catch (IOException ex) {
            throw new UxBuilderSchemaServiceException(ex, CdError.create((CdErrorCode)UxErrorCode.ERROR_UNEXPECTED, (Serializable[])new Serializable[]{"could not retrieve schema def. revisions: " + this.fixErrorMessageForBuilderPath(ex)}));
        }
    }

    @Nullable
    CdVFileRevFolder getRevDirectory(String relPath) {
        CdVFileRevHelperConf configuration = new CdVFileRevHelperConf(CdVFileRevManagerKind.SCHEMA_BUILDER, this.tmpDirectory, this.builderDirectory);
        return this.vfs.getRevDirectory(configuration, (name, payload) -> {
            try {
                OlapSchemaFactoryInfo info = OlapSchemaFactoryInfoParser.parse((File)payload);
                return info.getName();
            }
            catch (OlapSchemaFactoryInfoError ex) {
                OlapLoggers.VFS.error((Object)("[vfs] could not unmarshall the payload of schema def. revision for : " + name), (Throwable)ex);
                return null;
            }
        }, relPath);
    }

    void forEachRevDirectory(Consumer<CdVFileRevFolder> consumer) {
        CdVFileRevHelperConf configuration = new CdVFileRevHelperConf(CdVFileRevManagerKind.SCHEMA_BUILDER, this.tmpDirectory, this.builderDirectory);
        this.vfs.forEachRevDirectory(configuration, (name, payload) -> {
            try {
                OlapSchemaFactoryInfo info = OlapSchemaFactoryInfoParser.parse((File)payload);
                return info.getName();
            }
            catch (OlapSchemaFactoryInfoError ex) {
                OlapLoggers.VFS.error((Object)("[vfs] could not unmarshall the payload of schema def. revision for : " + name), (Throwable)ex);
                return null;
            }
        }, consumer);
    }

    UxBuilderSchema restoreRevDirectory(String savedBy, String relPath) {
        try {
            CdVFileRevHelperConf configuration = new CdVFileRevHelperConf(CdVFileRevManagerKind.SCHEMA_BUILDER, this.tmpDirectory, this.builderDirectory);
            File xml = this.vfs.restoreRevDirectory(configuration, savedBy, relPath);
            return this.unmarshallSchemaDefinition(xml);
        }
        catch (IOException ex) {
            throw new UxBuilderSchemaServiceException(ex, CdError.create((CdErrorCode)UxErrorCode.ERROR_UNEXPECTED, (Serializable[])new Serializable[]{"could not restore the schema def. revision: " + this.fixErrorMessageForBuilderPath(ex)}));
        }
    }

    void forEachSchemaShortInfo(Predicate<OlapSchemaFactoryInfo> consumer) {
        try {
            this.forEachSchemaShortInfo(this.builderDirectory.toPath(), consumer);
        }
        catch (IOException ex) {
            throw new UxBuilderSchemaServiceException(ex, CdError.create((CdErrorCode)UxErrorCode.ERROR_UNEXPECTED, (Serializable[])new Serializable[]{"could not retrieve schema definitions: " + this.fixErrorMessageForBuilderPath(ex)}));
        }
    }

    private void forEachSchemaShortInfo(Path path, Predicate<OlapSchemaFactoryInfo> consumer) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
            for (Path entry : stream) {
                File file = entry.toFile();
                String name = file.getName();
                if (name.endsWith(".icc-schema")) {
                    File schemaFile = entry.toFile();
                    try {
                        OlapSchemaFactoryInfo info = OlapSchemaFactoryInfoParser.parse((File)schemaFile);
                        if (consumer.test(info)) continue;
                        break;
                    }
                    catch (OlapSchemaFactoryInfoError | RuntimeException ex) {
                        OlapLoggers.UX_REQUEST_BUILDER.warn((Object)("[ux.builder]" + this.tenantInfo + " could not retrieve schema information [" + schemaFile.getName() + "]"), ex);
                        continue;
                    }
                }
                if (!file.isDirectory() || CdVFileSystem.isRevFolder((File)file)) continue;
                this.forEachSchemaShortInfo(entry, consumer);
            }
        }
    }

    void saveSchemaDefForCreate(String savedBy, UxBuilderSchemaLock lock, UxBuilderSchema createdSchema) {
        String schemaName = createdSchema.getName();
        File file = this.createFile(schemaName);
        if (file.exists()) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.SCHEMA_FILE_EXISTING, (Serializable[])new Serializable[]{file.getName()}));
        }
        OlapBuilderBaseSchemaDefFactory factory = createdSchema.getFactory();
        factory.setXmlFile(file);
        try {
            String operation = "created";
            this.unsafeMarshallSchemaDef(lock, createdSchema, false, (CdVFileRevAction)new CdVFileRevActionOperation(savedBy, "created"));
        }
        catch (JAXBException | IOException ex) {
            throw new UxBuilderSchemaServiceException((Exception)ex, CdError.create((CdErrorCode)UxErrorCode.FILE_IO_ERROR, (Serializable[])new Serializable[]{file.getName(), this.fixErrorMessageForBuilderPath((Exception)ex)}));
        }
    }

    void saveSchemaDefForUpload(String savedBy, UxBuilderSchemaLock lock, UxBuilderSchema uploadedSchema) {
        String schemaName = uploadedSchema.getName();
        File file = this.createFile(schemaName);
        OlapBuilderBaseSchemaDefFactory factory = uploadedSchema.getFactory();
        factory.setXmlFile(file);
        try {
            String operation = "uploaded";
            this.unsafeMarshallSchemaDef(lock, uploadedSchema, false, (CdVFileRevAction)new CdVFileRevActionOperation(savedBy, "uploaded"));
        }
        catch (JAXBException | IOException ex) {
            throw new UxBuilderSchemaServiceException((Exception)ex, CdError.create((CdErrorCode)UxErrorCode.FILE_IO_ERROR, (Serializable[])new Serializable[]{file.getName(), this.fixErrorMessageForBuilderPath((Exception)ex)}));
        }
    }

    void saveSchemaDefForXmlEdition(String savedBy, UxBuilderSchemaLock lock, UxBuilderSchema editedSchema) {
        String schemaName = editedSchema.getName();
        try {
            String operation = "manually edited";
            this.unsafeMarshallSchemaDef(lock, editedSchema, true, (CdVFileRevAction)new CdVFileRevActionOperation(savedBy, "manually edited"));
        }
        catch (JAXBException | IOException ex) {
            throw new UxBuilderSchemaServiceException((Exception)ex, CdError.create((CdErrorCode)UxErrorCode.FILE_IO_ERROR, (Serializable[])new Serializable[]{schemaName, this.fixErrorMessageForBuilderPath((Exception)ex)}));
        }
    }

    UxBuilderSchema saveSchemaDefForDuplicate(String savedBy, File file, String schemaName, @Nullable String schemaDescription, @Nullable String schemaGroup) {
        File fileNew = this.createFile(schemaName);
        if (fileNew.exists()) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.SCHEMA_FILE_EXISTING, (Serializable[])new Serializable[]{fileNew.getName()}));
        }
        UxBuilderSchema schemaNew = this.unmarshallSchemaDefinition(file);
        UxBuilderSchemaLock lock = new UxBuilderSchemaLock(UxBuilderSchemaLockKind.READ, schemaNew);
        OlapBuilderBaseSchemaDefFactory factoryNew = schemaNew.getFactory();
        factoryNew.setXmlFile(fileNew);
        factoryNew.setRevisionNumber(0);
        OlapBuilderSchema definitionNew = schemaNew.getDefinition(lock);
        definitionNew.setName(schemaName);
        definitionNew.setDescription(schemaDescription);
        definitionNew.setGroup(schemaGroup);
        try {
            String operation = "duplicated";
            this.unsafeMarshallSchemaDef(lock, schemaNew, false, (CdVFileRevAction)new CdVFileRevActionOperation(savedBy, "duplicated"));
            return schemaNew;
        }
        catch (JAXBException | IOException ex) {
            throw new UxBuilderSchemaServiceException((Exception)ex, CdError.create((CdErrorCode)UxErrorCode.FILE_IO_ERROR, (Serializable[])new Serializable[]{fileNew.getName(), this.fixErrorMessageForBuilderPath((Exception)ex)}));
        }
    }

    void saveSchemaDefForBookmark(UxBuilderSchemaLock lock, UxBuilderSchema schema, String savedBy, String bookmark) {
        try {
            this.unsafeMarshallSchemaDef(lock, schema, true, (CdVFileRevAction)new CdVFileRevActionBookmark(savedBy, bookmark));
        }
        catch (JAXBException | IOException ex) {
            throw new UxBuilderSchemaServiceException((Exception)ex, CdError.create((CdErrorCode)UxErrorCode.FILE_IO_ERROR, (Serializable[])new Serializable[]{schema.getName(), this.fixErrorMessageForBuilderPath((Exception)ex)}));
        }
    }

    void saveSchemaDef(String savedBy, UxBuilderSchemaLock lock, UxBuilderSchema schema, String operation) {
        try {
            this.unsafeMarshallSchemaDef(lock, schema, true, (CdVFileRevAction)new CdVFileRevActionOperation(savedBy, operation));
        }
        catch (JAXBException | IOException ex) {
            throw new UxBuilderSchemaServiceException((Exception)ex, CdError.create((CdErrorCode)UxErrorCode.FILE_IO_ERROR, (Serializable[])new Serializable[]{schema.getName(), this.fixErrorMessageForBuilderPath((Exception)ex)}));
        }
    }

    OlapBuilderSchemaDefFactory copySchemaDef(OlapBuilderSchemaDefFactory schema) throws IOException, JAXBException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));){
            CdXmlUtils.marshall((Writer)writer, (Object)schema, (Class[])this.metaInformation.getPersistentClasses());
        }
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));){
            OlapBuilderSchemaDefFactory definition;
            OlapBuilderSchemaDefFactory olapBuilderSchemaDefFactory = definition = (OlapBuilderSchemaDefFactory)CdXmlUtils.unmarshall((File)schema.getXmlFile(), (Reader)reader, (Class[])this.metaInformation.getPersistentClasses());
            return olapBuilderSchemaDefFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsafeMarshallSchemaDef(UxBuilderSchemaLock lock, UxBuilderSchema definition, boolean optimisticLocking, CdVFileRevAction action) throws JAXBException, IOException {
        OlapBuilderBaseSchemaDefFactory factory = definition.getFactory();
        File xml = factory.getXmlFile();
        if (xml == null) {
            throw new IOException("internal error: missing XML file for schema [" + definition.getName() + "]");
        }
        if (optimisticLocking && xml.exists()) {
            int revNumber;
            OlapSchemaFactoryInfo info = this.getSchemaShortInfo(xml, false);
            int expectedRevNumber = definition.getRevNumber();
            if (expectedRevNumber != (revNumber = info.getRevNumber())) {
                throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.SCHEMA_REV_NUMBER_MISMATCH, (Serializable[])new Serializable[]{definition.getName(), Integer.valueOf(revNumber), Integer.valueOf(expectedRevNumber)}));
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));){
                if (optimisticLocking) {
                    factory.setRevisionNumber(factory.getRevisionNumber() + 1);
                }
                try {
                    OlapLoggers.UX_REQUEST_BUILDER.debug((Object)"[ux.builder] marshall schema def.: started");
                    CdXmlUtils.marshall((Writer)writer, (Object)factory, (Class[])this.metaInformation.getPersistentClasses());
                }
                catch (JAXBException | RuntimeException ex) {
                    if (optimisticLocking) {
                        factory.setRevisionNumber(factory.getRevisionNumber() - 1);
                    }
                    throw ex;
                }
            }
            try (ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());){
                OlapLoggers.UX_REQUEST_BUILDER.debug((Object)"[ux.builder] marshall schema def.: revision");
                CdVFileRevHelperConf configuration = new CdVFileRevHelperConf(CdVFileRevManagerKind.SCHEMA_BUILDER, this.tmpDirectory, this.builderDirectory);
                this.vfs.saveOrUpdateWithRevision(configuration, xml, (InputStream)in, action);
            }
        }
        finally {
            OlapLoggers.UX_REQUEST_BUILDER.debug((Object)"[UX] marshall schema def.: completed");
        }
    }

    boolean isExisting(String schemaName) {
        MutableBoolean existing = new MutableBoolean();
        this.forEachSchemaShortInfo(factory -> {
            if (schemaName.equals(factory.getName())) {
                existing.setValue(true);
                return false;
            }
            return true;
        });
        return existing.booleanValue();
    }

    OlapSchemaFactoryInfo getSchemaShortInfo(File file, boolean withDef) {
        OlapSchemaFactoryInfo info;
        try {
            info = OlapSchemaFactoryInfoParser.parse((File)file);
        }
        catch (OlapSchemaFactoryInfoError | RuntimeException ex) {
            throw new UxBuilderSchemaServiceException((Exception)ex, CdError.create((CdErrorCode)UxErrorCode.SCHEMA_DEF_ERROR, (Serializable[])new Serializable[]{file.getName(), ex.getMessage()}));
        }
        if (withDef) {
            try {
                String content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                info.setContentDef(content);
            }
            catch (IOException | RuntimeException ex) {
                throw new UxBuilderSchemaServiceException(ex, CdError.create((CdErrorCode)UxErrorCode.SCHEMA_DEF_ERROR, (Serializable[])new Serializable[]{file.getName(), ex.getMessage()}));
            }
        }
        return info;
    }

    @Nullable
    OlapSchemaFactoryInfo getSchemaShortInfo(UxSchemaId schemaId, boolean withDef) {
        try {
            if (schemaId.schemaFile != null) {
                File file = UxBuilderSchemaRepositoryHelper.createBuilderFile(this.vfs, this.builderDirectory, schemaId.schemaFile);
                return this.getSchemaShortInfo(file, withDef);
            }
            if (schemaId.schemaName != null) {
                OlapSchemaFactoryInfo[] found = new OlapSchemaFactoryInfo[1];
                this.forEachSchemaShortInfo(factory -> {
                    if (schemaId.schemaName.equals(factory.getName())) {
                        found[0] = this.getSchemaShortInfo(factory.getFile(), withDef);
                        return false;
                    }
                    return true;
                });
                return found[0];
            }
            return null;
        }
        catch (RuntimeException ex) {
            OlapLoggers.UX_REQUEST_BUILDER.error((Object)("[ux.builder] could not retrieve the schema short info " + String.valueOf(schemaId)), (Throwable)ex);
            return null;
        }
    }

    @Nullable
    UxBuilderSchema unmarshallSchemaDefinition(UxSchemaId schemaId) {
        OlapSchemaFactoryInfo info = this.getSchemaShortInfo(schemaId, false);
        if (info != null) {
            File file = info.getFile();
            return this.unmarshallSchemaDefinition(file);
        }
        return null;
    }

    UxBuilderSchema unmarshallSchemaDefinition(File file) {
        try {
            OlapBuilderBaseSchemaDefFactory definition = (OlapBuilderBaseSchemaDefFactory)CdXmlUtils.unmarshall((String)"UTF-8", (File)file, (Class[])this.metaInformation.getPersistentClasses());
            definition.setXmlFile(file);
            return new UxBuilderSchema(definition);
        }
        catch (JAXBException | IOException ex) {
            throw new UxBuilderSchemaServiceException((Exception)ex, CdError.create((CdErrorCode)UxErrorCode.SCHEMA_DEF_ERROR, (Serializable[])new Serializable[]{file.getName(), this.fixErrorMessageForBuilderPath((Exception)ex)}));
        }
    }

    UxBuilderSchema unmarshallSchemaDefForUpload(String fileName, UxServerRequestParams params) {
        try {
            InputStreamReader reader = new InputStreamReader(params.getInputStream(), StandardCharsets.UTF_8);
            OlapBuilderBaseSchemaDefFactory definition = (OlapBuilderBaseSchemaDefFactory)CdXmlUtils.unmarshall(null, (Reader)reader, (Class[])this.metaInformation.getPersistentClasses());
            return new UxBuilderSchema(definition);
        }
        catch (JAXBException | IOException ex) {
            throw new UxBuilderSchemaServiceException((Exception)ex, CdError.create((CdErrorCode)UxErrorCode.SCHEMA_DEF_ERROR, (Serializable[])new Serializable[]{fileName, this.fixErrorMessageForBuilderPath((Exception)ex)}));
        }
    }

    UxBuilderSchema unmarshallSchemaDefXmlEdition(String schemaName, String content) {
        try {
            StringReader reader = new StringReader(content);
            OlapBuilderBaseSchemaDefFactory definition = (OlapBuilderBaseSchemaDefFactory)CdXmlUtils.unmarshall(null, (Reader)reader, (Class[])this.metaInformation.getPersistentClasses());
            return new UxBuilderSchema(definition);
        }
        catch (JAXBException ex) {
            throw new UxBuilderSchemaServiceException((Exception)((Object)ex), CdError.create((CdErrorCode)UxErrorCode.SCHEMA_DEF_ERROR, (Serializable[])new Serializable[]{schemaName, this.fixErrorMessageForBuilderPath((Exception)((Object)ex))}));
        }
    }

    boolean deleteSchema(UxSchemaId schemaId) {
        if (schemaId.schemaFile != null) {
            File file = UxBuilderSchemaRepositoryHelper.createBuilderFile(this.vfs, this.builderDirectory, schemaId.schemaFile);
            return file.delete();
        }
        if (schemaId.schemaName != null) {
            MutableBoolean deleted = new MutableBoolean();
            this.forEachSchemaShortInfo(factory -> {
                try {
                    UxBuilderSchema definition = this.unmarshallSchemaDefinition(factory.getFile());
                    if (schemaId.schemaName.equals(definition.getName()) && factory.getFile().delete()) {
                        deleted.setValue(true);
                    }
                    return true;
                }
                catch (RuntimeException ignored) {
                    return true;
                }
            });
            return deleted.booleanValue();
        }
        return false;
    }

    private File createFile(String schemaName) {
        String fileName = CdVFileSystem.toFileName((String)schemaName);
        String fileNameExt = fileName + ".icc-schema";
        File file = UxBuilderSchemaRepositoryHelper.createBuilderFile(this.vfs, this.builderDirectory, fileNameExt);
        return file;
    }

    private String fixErrorMessageForBuilderPath(Exception error) {
        String message = error.getMessage();
        try {
            String path = this.builderDirectory.getPath();
            String fixed = message.replace(path, "");
            return fixed;
        }
        catch (RuntimeException runtimeException) {
            return message;
        }
    }
}

