/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.service;

import com.google.common.cache.CacheBuilder;
import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfo;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaCacheStats;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaRepository;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaRepositoryHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

class UxBuilderSchemaCacheGuts {
    private final Map<String, UxBuilderSchema> unmarshalledSchemasByName = CacheBuilder.newBuilder().softValues().build().asMap();
    private final String tenantInfo;

    UxBuilderSchemaCacheGuts(String tenantInfo) {
        this.tenantInfo = tenantInfo;
    }

    UxBuilderSchemaCacheStats stats() {
        ArrayList<UxBuilderSchemaCacheStats.Prop> props = new ArrayList<UxBuilderSchemaCacheStats.Prop>();
        ArrayList<String> defNames = new ArrayList<String>(this.unmarshalledSchemasByName.keySet());
        defNames.sort(String::compareToIgnoreCase);
        props.add(new UxBuilderSchemaCacheStats.Prop("schema definitions count", "" + defNames.size()));
        if (defNames.size() > 0) {
            StringBuilder sb = new StringBuilder();
            int count = 1;
            for (String entry : defNames) {
                sb.append(String.format("%-4s : %s \n", count++, entry));
            }
            props.add(new UxBuilderSchemaCacheStats.Prop("schema definitions", sb.toString()));
        }
        return new UxBuilderSchemaCacheStats(props);
    }

    @Nullable
    UxBuilderSchema getSchema(UxBuilderSchemaRepository repository, UxSchemaId schemaId) {
        if (schemaId.schemaName != null) {
            return this.unmarshalledSchemasByName.get(schemaId.schemaName);
        }
        if (schemaId.schemaFile != null && !this.unmarshalledSchemasByName.isEmpty()) {
            File file = UxBuilderSchemaRepositoryHelper.createBuilderFile(repository.getVfs(), repository.getBuilderDirectory(), schemaId.schemaFile);
            for (Map.Entry<String, UxBuilderSchema> entry : this.unmarshalledSchemasByName.entrySet()) {
                try {
                    File xml = entry.getValue().getFactory().getXmlFile();
                    if (xml == null || !Files.isSameFile(xml.toPath(), file.toPath())) continue;
                    return entry.getValue();
                }
                catch (IOException iOException) {
                }
            }
        }
        return null;
    }

    void addSchema(UxBuilderSchema schema) {
        OlapSchemaFactoryInfo info = schema.getInfo();
        UxBuilderSchema existing = this.unmarshalledSchemasByName.get(schema.getName());
        if (existing != null) {
            OlapLoggers.UX_REQUEST_BUILDER.warn((Object)("[ux.builder]" + this.tenantInfo + " re-indexing schema definition [" + schema.getName() + "] with file [ " + String.valueOf(info.getFile()) + " ]"));
        }
        this.unmarshalledSchemasByName.put(schema.getName(), schema);
    }

    void removeSchemaDefinition(@Nullable String schemaName) {
        if (schemaName != null) {
            this.unmarshalledSchemasByName.remove(schemaName);
        }
    }

    void onSchemaCreated(UxBuilderSchema createdSchema) {
        this.addSchema(createdSchema);
    }

    void onSchemaUploaded(UxBuilderSchema uploadedSchema) {
        this.addSchema(uploadedSchema);
    }

    void onSchemaRestored(UxBuilderSchema restoredSchema) {
        this.addSchema(restoredSchema);
    }

    void onSchemaXmlEdited(UxBuilderSchema editedSchema) {
        this.addSchema(editedSchema);
    }

    void onSchemaDuplicated(UxBuilderSchema duplicatedSchema) {
        this.addSchema(duplicatedSchema);
    }

    void onSchemaSaved(UxBuilderSchemaRepository repository, UxBuilderSchema schema, boolean onError) {
        if (onError) {
            OlapSchemaFactoryInfo info = schema.getInfo();
            this.onSchemaDeleted(repository, new UxSchemaId(info.getName(), null));
            return;
        }
        this.addSchema(schema);
    }

    void onSchemaDeleted(UxBuilderSchemaRepository repository, UxSchemaId schemaId) {
        if (schemaId.schemaName != null) {
            this.unmarshalledSchemasByName.remove(schemaId.schemaName);
            return;
        }
        if (schemaId.schemaFile != null && !this.unmarshalledSchemasByName.isEmpty()) {
            File file = UxBuilderSchemaRepositoryHelper.createBuilderFile(repository.getVfs(), repository.getBuilderDirectory(), schemaId.schemaFile);
            ArrayList<String> toDelete = new ArrayList<String>();
            for (Map.Entry<String, UxBuilderSchema> entry : this.unmarshalledSchemasByName.entrySet()) {
                try {
                    File xml = entry.getValue().getFactory().getXmlFile();
                    if (xml == null || !Files.isSameFile(xml.toPath(), file.toPath())) continue;
                    toDelete.add(entry.getKey());
                }
                catch (IOException iOException) {}
            }
            for (String name : toDelete) {
                this.unmarshalledSchemasByName.remove(name);
            }
        }
    }
}

