/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.service;

import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfo;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaCacheGuts;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaCacheStats;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaRepository;
import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Nullable;

class UxBuilderSchemaCache {
    private final UxBuilderSchemaRepository repository;
    private final AtomicReference<UxBuilderSchemaCacheGuts> guts;

    UxBuilderSchemaCache(UxBuilderSchemaRepository repository) {
        this.repository = repository;
        this.guts = new AtomicReference<UxBuilderSchemaCacheGuts>(new UxBuilderSchemaCacheGuts(repository.getTenantInfo()));
    }

    void refresh() {
        OlapLoggers.UX_REQUEST_BUILDER.info((Object)("[ux.builder]" + this.repository.getTenantInfo() + " refresh schema def. cache started"));
        try {
            this.guts.set(new UxBuilderSchemaCacheGuts(this.repository.getTenantInfo()));
        }
        finally {
            OlapLoggers.UX_REQUEST_BUILDER.info((Object)("[ux.builder]" + this.repository.getTenantInfo() + " refresh schema def. cache completed"));
        }
    }

    void removeSchemaDefinition(UxSchemaId schemaId) {
        OlapLoggers.UX_REQUEST_BUILDER.info((Object)("[ux.builder]" + this.repository.getTenantInfo() + " removing schema def. from cache : " + schemaId.toString()));
        this.guts.get().removeSchemaDefinition(schemaId.schemaName);
    }

    UxBuilderSchemaCacheStats stats() {
        return this.guts.get().stats();
    }

    @Nullable
    UxBuilderSchema getSchemaEx(UxSchemaId schemaId) {
        UxBuilderSchema schemaFromCache = this.guts.get().getSchema(this.repository, schemaId);
        try {
            File schemaFile;
            OlapSchemaFactoryInfo infoFromDisk;
            int revNumberFromDisk;
            if (schemaFromCache == null) {
                UxBuilderSchema schema = this.repository.unmarshallSchemaDefinition(schemaId);
                if (schema != null) {
                    this.addSchema(schema);
                    return schema;
                }
                return null;
            }
            OlapSchemaFactoryInfo infoFromCache = schemaFromCache.getInfo();
            int revNumberFromCache = schemaFromCache.getRevNumber();
            if (revNumberFromCache == (revNumberFromDisk = (infoFromDisk = this.repository.getSchemaShortInfo(schemaFile = infoFromCache.getFile(), false)).getRevNumber())) {
                return schemaFromCache;
            }
            OlapLoggers.BUILDER.warn((Object)("[builder] cached definition for [" + schemaId.schemaName + "] is out-of-sync [" + revNumberFromCache + "][" + revNumberFromDisk + "] => updating the cache"));
            UxBuilderSchema schema = this.repository.unmarshallSchemaDefinition(schemaFile);
            this.addSchema(schema);
            return schema;
        }
        catch (RuntimeException ex) {
            OlapLoggers.UX_REQUEST_BUILDER.error((Object)("[ux.builder] could not retrieve the schema " + String.valueOf(schemaId)), (Throwable)ex);
            try {
                this.guts.get().onSchemaDeleted(this.repository, schemaId);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return null;
        }
    }

    void addSchema(UxBuilderSchema schema) {
        this.guts.get().addSchema(schema);
    }

    void onSchemaCreated(UxBuilderSchema uploadedSchema) {
        this.guts.get().onSchemaCreated(uploadedSchema);
    }

    void onSchemaUploaded(UxBuilderSchema uploadedSchema) {
        this.guts.get().onSchemaUploaded(uploadedSchema);
    }

    void onSchemaRestored(UxBuilderSchema restoredSchema) {
        this.guts.get().onSchemaRestored(restoredSchema);
    }

    void onSchemaXmlEdited(UxBuilderSchema editedSchema) {
        this.guts.get().onSchemaXmlEdited(editedSchema);
    }

    void onSchemaDuplicated(UxBuilderSchema duplicatedSchema) {
        this.guts.get().onSchemaDuplicated(duplicatedSchema);
    }

    void onSchemaSaved(UxBuilderSchema schema, boolean onError) {
        this.guts.get().onSchemaSaved(this.repository, schema, onError);
    }

    void onSchemaDeleted(UxSchemaId schemaId) {
        this.guts.get().onSchemaDeleted(this.repository, schemaId);
    }
}

