/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.script;

import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.IOlapBuilderScriptDef;
import crazydev.iccube.builder.model.validation.OlapBuilderSchemaValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.contextual.IOlapContextual;
import crazydev.iccube.contextual.OlapContextualBigException;
import crazydev.iccube.contextual.OlapContextualError;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.command.builtin.OlapEngineOfflineMode;
import crazydev.iccube.olap.eval.function.OlapFunctionRepository;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchemaFunctionRepository;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.utils.UxUtils;
import crazydev.iccube.ux.common.validation.UxValidationResult;
import crazydev.iccube.ux.processor.UxServerRequestContext;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class UxSchemaScriptValidator {
    private UxSchemaScriptValidator() {
    }

    @Nullable
    public static UxValidationResult validate(UxQueryContext queryContext, IOlapBuilderSchemaDef schemaDef, IOlapBuilderScriptDef script) {
        UxValidationResult result = UxSchemaScriptValidator.validateScript(queryContext, schemaDef, script);
        if (result != null && result.hasErrors()) {
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static UxValidationResult validateScript(UxQueryContext queryContext, IOlapBuilderSchemaDef schemaDef, IOlapBuilderScriptDef script) {
        UxServerRequestContext context = queryContext.asServerRequestContext();
        OlapBuilderErrorManager errorManager = new OlapBuilderErrorManager(false);
        OlapBuilderConnectionPool connectionPool = new OlapBuilderConnectionPool();
        OlapEngineComponent engine = context.getOlapEngineComponent();
        OlapProperties properties = engine.getProperties();
        OlapFunctionRepository functionRepository = engine.getFunctionRepository();
        OlapSchemaFunctionRepository schemaFunctionRepository = new OlapSchemaFunctionRepository(functionRepository);
        OlapBuilderValidationContext validationContext = new OlapBuilderValidationContext(context.asRuntimeContext(), false, OlapEngineOfflineMode.OFF, context.isPerspectivesLicensed(), context.isTablePartitioningLicensed(), context.isFactsPartitioningLicensed(), context.isJavaMdxNativesActivated(), properties, functionRepository, schemaFunctionRepository.createSnapshot(), context.getOlapEngineComponent().getModuleMethodsRepository(), connectionPool, errorManager);
        errorManager.pushContext((IOlapContextual)schemaDef);
        try {
            UxSchemaScriptValidator.doValidateScript(validationContext, schemaDef, script);
            UxValidationResult uxValidationResult = null;
            return uxValidationResult;
        }
        catch (OlapContextualBigException ex) {
            UxValidationResult uxValidationResult = UxUtils.setupValidationResult(queryContext, context.getBabylonService(), errorManager.getErrors());
            return uxValidationResult;
        }
        finally {
            connectionPool.close();
        }
    }

    private static void doValidateScript(OlapBuilderValidationContext validationContext, IOlapBuilderSchemaDef schemaDef, IOlapBuilderScriptDef script) throws OlapContextualBigException {
        OlapBuilderErrorManager errorManager = (OlapBuilderErrorManager)validationContext.getErrorManager();
        try {
            OlapBuilderSchemaValidator.validateScript((OlapBuilderValidationContext)validationContext, (IOlapBuilderScriptDef)script, (List)schemaDef.getCubes());
            if (errorManager.hasErrors()) {
                throw errorManager.asException();
            }
        }
        catch (OlapBuilderErrorException ex) {
            OlapLoggers.UX_REQUEST.warn((Object)"[UX] schema script validation error-exception", (Throwable)ex);
            errorManager.addError((OlapContextualError)ex.getError());
            throw errorManager.asException();
        }
        catch (RuntimeException ex) {
            errorManager.addException(ex);
            throw errorManager.asException();
        }
    }
}

