/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.script;

import crazydev.iccube.builder.model.impl.OlapBuilderScript;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.utils.UxFileUtils;
import crazydev.iccube.ux.admin.queries.utils.UxFileWrapper;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.script.UxSaveSchemaScriptQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.url.UxUrlConstants;
import crazydev.iccube.ux.mdx.queries.completion.UxMdxCompletionKind;
import crazydev.iccube.ux.mdx.queries.completion.UxMdxCompletionQueryMeta;
import crazydev.iccube.ux.mdx.queries.init.UxMdxConsoleHomeQuery;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.stream.Collectors;

public class UxSchemaScriptQuery
extends UxSchemaBuilderQuery {
    public UxSchemaScriptQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId) {
        super(meta, requestId, schemaId);
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            UxBabylonService babylon = queryContext.getUxBabylonService();
            int revNumber = schema.getRevNumber();
            OlapBuilderScript script = schema.getScript(lock);
            String content = script.getContent();
            String additionalHelp = babylon.translate("mdxOnlineHelp", new Serializable[]{"<a href='" + UxUrlConstants.HELP_MDX.toUrl() + "' target='_blank'>www</a>."});
            OlapEngineComponent engine = queryContext.getOlapEngineComponent();
            HashMap<String, Object> completionUtils = new HashMap<String, Object>();
            completionUtils.put("mdxFunctions", engine.getAllFunctions().stream().map(OlapFunction::getName).collect(Collectors.toList()));
            completionUtils.put("mdxTokens", UxMdxConsoleHomeQuery.setupMdxTokens());
            UxAction completion = UxMdxCompletionQueryMeta.createAction(queryContext, UxMdxCompletionKind.BUILDER_SCRIPT, schema.getName());
            UxAction save = UxSaveSchemaScriptQueryMeta.createAction(queryContext, this.schemaId, revNumber);
            UxFileWrapper wrapper = UxSchemaScriptQuery.setupFileWrapper(content);
            return UxFileUtils.createFileContent(queryContext, this.meta.queryName(), wrapper, additionalHelp, completion, completionUtils, save);
        });
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxBuilderUseCaseName.SchemaScript, this.schemaId));
    }

    private static UxFileWrapper setupFileWrapper(String content) {
        if (content == null) {
            content = "";
        }
        final byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
        return new UxFileWrapper(){

            @Override
            public String getName() {
                return "schema-script";
            }

            @Override
            public String getCodeMirrorMode() {
                return "cm-mdx";
            }

            @Override
            public String getMimeType() {
                return "text/plain";
            }

            @Override
            public boolean deleteOnExit() {
                return false;
            }

            @Override
            public String getAbsolutePath() {
                return this.getName();
            }

            @Override
            public boolean exists() {
                return true;
            }

            @Override
            public long length() {
                return bytes.length;
            }

            @Override
            public InputStream createInputStream() throws IOException {
                return new ByteArrayInputStream(bytes);
            }

            @Override
            public Reader createInputStreamReader(InputStream in) {
                return new InputStreamReader(in, StandardCharsets.UTF_8);
            }

            @Override
            public boolean delete() {
                return false;
            }
        };
    }
}

