/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.schema;

import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfo;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaFactoryFile;
import crazydev.iccube.ux.admin.queries.utils.UxRowFilters;
import crazydev.iccube.ux.builder.UxBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.init.UxSchemaBuilderHomeQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.filter.UxFilterMeta;
import crazydev.iccube.ux.common.filter.UxFilterMetas;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableMeta;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableRowSearcher;
import crazydev.iccube.ux.common.table.UxTableSearcher;
import crazydev.iccube.ux.common.table.UxTableSortType;
import crazydev.iccube.ux.common.table.UxTableWithUseCasesReplyPayload;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import crazydev.iccube.ux.common.utils.UxUtils;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class UxSchemaDefsQuery
extends UxBuilderQuery {
    @Nullable
    private final UxTableOptions tableOptions;

    public UxSchemaDefsQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId);
        this.tableOptions = tableOptions;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        UxTableHeaders header = UxTableHeaders.create(babylon, "name", "group", "schemaDefinitionUpdateTime", "fileName");
        UxFilterMetas filterMetas = new UxFilterMetas(new UxFilterMeta<OlapSchemaFactoryInfo>("group", babylon.translate("filterSchemaGroup", new Serializable[0]), OlapSchemaFactoryInfo::getGroup), new UxFilterMeta<OlapSchemaFactoryInfo>("schema", babylon.translate("filterSchemaName", new Serializable[0]), OlapSchemaFactoryInfo::getName));
        UxTableSearcher rowSearcher = this.setupRowSearcher(this.tableOptions, new UxTableRowSearcher<OlapSchemaFactoryInfo>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public boolean isAccepting(OlapSchemaFactoryInfo row, String searchText) {
                return this.isContaining(searchText, row.getName(), row.getGroup());
            }
        });
        UxRowFilters rowFilters = this.setupRowFilters(this.tableOptions, filterMetas);
        ArrayList schemas = new ArrayList();
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        OlapLoggers.UX_REQUEST_BUILDER.debug((Object)"[ux.builder] schema-defs query: for-each started");
        service.forEachSchemaShortInfo(schema -> {
            if ((rowSearcher == null || rowSearcher.isAccepting(schema)) && (rowFilters == null || rowFilters.isAccepting(schema))) {
                schemas.add(schema);
            }
            return true;
        });
        OlapLoggers.UX_REQUEST_BUILDER.debug((Object)"[ux.builder] schema-defs query: for-each done");
        int totalRowCount = schemas.size();
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.createForFirstPageWithDefaults(queryContext.getApi(), "schemaDefinitionUpdateTime", UxTableSortType.desc, totalRowCount));
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        for (OlapSchemaFactoryInfo schema2 : schemas) {
            rows.add(UxSchemaDefsQuery.createRow(queryContext, schema2));
        }
        UxTable table = UxTable.create(options, header, rows);
        List<UxTableRow> actualRows = table.getRows();
        if (actualRows != null) {
            for (UxTableRow actualRow : actualRows) {
                UxSchemaDefsQuery.setupRowUseCase(queryContext, actualRow);
            }
        }
        UxTableMeta tableMeta = new UxTableMeta(true, filterMetas);
        return UxReply.success(new UxTableWithUseCasesReplyPayload(tableMeta, table));
    }

    private static UxTableRow createRow(UxQueryContext context, OlapSchemaFactoryInfo schema) {
        UxBabylonService babylon = context.getUxBabylonService();
        UxSchemaFactoryFile schemaFile = UxSchemaFactoryFile.fromFile(context, true, schema.getFile());
        String path = schemaFile.relativePath();
        UxUseCase useCase = null;
        long lastEditedTime = schema.lastModified();
        String lastEditedTime_ = lastEditedTime > 0L ? UxUtils.formatTimeServer(babylon, new Date(lastEditedTime)) : "";
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        cells.add(new UxTableCell((Object)schema.getName(), useCase));
        cells.add(new UxTableCell(schema.getGroup() != null ? schema.getGroup() : ""));
        cells.add(new UxTableCell(lastEditedTime_).withValue_(lastEditedTime));
        cells.add(new UxTableCell(path));
        UxTableRow row = new UxTableRow(cells);
        row.setData(schema);
        return row;
    }

    private static void setupRowUseCase(UxQueryContext context, UxTableRow row) {
        OlapSchemaFactoryInfo schema = (OlapSchemaFactoryInfo)row.getData();
        String schemaName = schema.getName();
        UxSchemaFactoryFile schemaFile = UxSchemaFactoryFile.fromFile(context, true, schema.getFile());
        String schemaPath = schemaFile.relativePath();
        UxSchemaId schemaId = new UxSchemaId(schemaName, schemaPath);
        UxUseCase useCase = new UxUseCaseBuilder(context, UxSchemaBuilderHomeQueryMeta.BuilderHomeS, schemaId).withId(UxBuilderUseCaseName.BuilderHomeS).build(true);
        row.setUseCase(useCase);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxBuilderUseCaseName.SchemaDefs));
    }
}

