/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.schema;

import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfo;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaFactoryFile;
import crazydev.iccube.ux.admin.queries.utils.UxFileUtils;
import crazydev.iccube.ux.admin.queries.utils.UxFileWrapper;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.schema.UxSaveSchemaDefFileQueryMeta;
import crazydev.iccube.ux.builder.queries.schema.UxSchemaDefFileQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;

public class UxSchemaDefFileQuery
extends UxSchemaBuilderQuery {
    public UxSchemaDefFileQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId) {
        super(meta, requestId, schemaId);
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        OlapSchemaFactoryInfo schema = service.getSchemaShortInfo(this.schemaId, true);
        String content = schema.getDefContent();
        UxSchemaFactoryFile schemaFile = UxSchemaFactoryFile.fromFile(queryContext, true, schema.getFile());
        String mimeType = queryContext.getMimeTypeByExtension(schemaFile.getName());
        UxFileWrapper wrapper = UxFileWrapper.forString(schemaFile.getName(), content, mimeType);
        UxAction save = UxSaveSchemaDefFileQueryMeta.createAction(queryContext, new UxSchemaId(this.schemaId.schemaName, schemaFile.relativePath()));
        return UxFileUtils.createFileContent(queryContext, this.meta.queryName(), wrapper, save);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(UxSchemaDefFileQueryMeta.createUseCase(queryContext, this.schemaId));
    }
}

