/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.schema;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.builder.OlapBuilderMetaInformationRepository;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import jakarta.xml.bind.JAXBException;
import java.io.Serializable;

public class UxSaveSchemaDefFileQuery
extends UxSchemaBuilderQuery {
    private final String fileContent;

    protected UxSaveSchemaDefFileQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, String fileContent) {
        super(meta, requestId, schemaId);
        this.fileContent = fileContent;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        String validatedFileContent;
        try {
            OlapEngineComponent engine = queryContext.getOlapEngineComponent();
            OlapBuilderMetaInformationRepository metaInformation = engine.getBuilderMetaInformationRepository();
            validatedFileContent = UxBuilderSchemaService.validateSchemaDefinition(metaInformation, this.fileContent);
        }
        catch (JAXBException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"could not save schema file", (Throwable)ex);
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.FILE_IO_ERROR, (Serializable[])new Serializable[]{ex.getMessage()}));
        }
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        service.saveSchemaDefForXmlEdition(queryContext.getUserName(), this.schemaId, validatedFileContent);
        return UxReply.actionSuccess();
    }
}

