/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.schema;

import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import org.jetbrains.annotations.Nullable;

public class UxDuplicateSchemaDefQuery
extends UxSchemaBuilderQuery {
    private final String dupSchemaName;
    private final String dupSchemaDescription;
    private final String dupSchemaGroup;

    public UxDuplicateSchemaDefQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, String dupSchemaName, @Nullable String dupSchemaDescription, @Nullable String dupSchemaGroup) {
        super(meta, requestId, schemaId);
        this.dupSchemaName = dupSchemaName;
        this.dupSchemaDescription = dupSchemaDescription;
        this.dupSchemaGroup = dupSchemaGroup;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, -1, (lock, schema) -> {
            service.saveSchemaDefForDuplicate(queryContext.getUserName(), lock, schema, this.dupSchemaName, this.dupSchemaDescription, this.dupSchemaGroup);
            UxSchemaId dupSchemaId = new UxSchemaId(this.dupSchemaName, null);
            UxUseCase useCase = queryContext.getUseCase(UxBuilderUseCaseName.BuilderHomeS, dupSchemaId);
            UxActionContinuation continuation = new UxActionContinuation(UxActionContinuationKind.NAVIGATE, useCase);
            return UxReply.actionSuccess(continuation);
        });
    }
}

