/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.schema;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.builder.factory.schema.OlapBuilderBaseSchemaDefFactory;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.component.schemas.OlapEngineSchemaDefFactoryHelper;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaFactoryFile;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaInfoQueryMeta;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderSchema;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionBuilder;
import crazydev.iccube.ux.common.action.UxActionNavigateContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class UxDeploySchemaDefQuery
extends UxSchemaBuilderQuery {
    protected UxDeploySchemaDefQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId) {
        super(meta, requestId, schemaId);
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            OlapRuntimeContext rContext;
            File destinationFile = UxDeploySchemaDefQuery.deploy(queryContext, schema);
            OlapEngineComponent engine = queryContext.getOlapEngineComponent();
            OlapSchemaInformation loadedSchema = engine.getLoadedSchemaInformation(rContext = queryContext.asRuntimeContext(), schema.getName());
            UxUseCase monitoringUC = loadedSchema != null ? UxSchemaInfoQueryMeta.createUseCaseForLoadedUnloaded(queryContext, loadedSchema, null, null) : UxSchemaInfoQueryMeta.createUseCaseForLoadedUnloaded(queryContext, null, schema.getName(), UxSchemaFactoryFile.fromFile(queryContext, false, destinationFile));
            UxBabylonService babylon = queryContext.getUxBabylonService();
            String synopsis = babylon.translate("schemaDefDeployedSuccessfully", new Serializable[]{schema.getName()});
            List<UxAction> actions = UxDeploySchemaDefQuery.setupContinuationActions(queryContext, monitoringUC);
            return UxReply.actionSuccess(new UxActionNavigateContinuation(synopsis, actions));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static File deploy(UxQueryContext queryContext, UxBuilderSchema schema) throws UxBuilderSchemaServiceException {
        OlapBuilderBaseSchemaDefFactory factory = schema.getFactory();
        File factoryFile = factory.getXmlFile();
        if (factoryFile == null) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.SCHEMA_DEF_FILE_NOT_AVAILABLE, (Serializable[])new Serializable[0]));
        }
        File destinationFile = UxDeploySchemaDefQuery.createDeployedFactoryFile(queryContext, factoryFile);
        try {
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(factoryFile));
                OlapEngineSchemaDefFactoryHelper helper = queryContext.getDeployedSchemaDefFactoryHelper();
                String savedBy = queryContext.getUserName();
                String operation = "deployed";
                helper.writeSchemaDefFactoryFileContent(savedBy, destinationFile, (InputStream)in, "deployed");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            if (OlapLoggers.UX_REQUEST_BUILDER.isDebugEnabled()) {
                OlapLoggers.UX_REQUEST_BUILDER.debug((Object)("[ux.builder] schema def. factory [" + factoryFile.getAbsolutePath() + "] deployed : " + destinationFile.getAbsolutePath() + "]"));
            }
            return destinationFile;
        }
        catch (IOException ex) {
            OlapLoggers.UX_REQUEST_BUILDER.error((Object)("[ux.builder] schema def. factory [" + factoryFile.getAbsolutePath() + "] deployment error [" + destinationFile.getAbsolutePath() + "]"), (Throwable)ex);
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.SCHEMA_DEF_FILE_DEPLOY_ERROR, (Serializable[])new Serializable[]{ex.getMessage()}));
        }
    }

    private static File createDeployedFactoryFile(UxQueryContext queryContext, File builderFactoryFile) {
        OlapDirectoriesResolved directories = queryContext.getResolvedDirectories();
        File builderDirectory = directories.getBuilderDirectory();
        String builderAbsPath = builderDirectory.getAbsolutePath();
        String factoryAbsPath = builderFactoryFile.getAbsolutePath();
        if (!factoryAbsPath.startsWith(builderAbsPath)) {
            OlapLoggers.UX_REQUEST_BUILDER.error((Object)("[ux.builder] schema factory file inconsistency [" + builderAbsPath + "][" + factoryAbsPath + "]"));
            throw new RuntimeException("internal error: inconsistent schema definition file name");
        }
        if (factoryAbsPath.length() <= builderAbsPath.length()) {
            OlapLoggers.UX_REQUEST_BUILDER.error((Object)("[ux.builder] schema factory file inconsistency (len) [" + builderAbsPath + "][" + factoryAbsPath + "]"));
            throw new RuntimeException("internal error: inconsistent schema definition file name");
        }
        String factoryRelPath = factoryAbsPath.substring(builderAbsPath.length());
        File cubesDirectory = directories.getCubesDirectory();
        File deployedFile = new File(cubesDirectory, factoryRelPath);
        return deployedFile;
    }

    private static List<UxAction> setupContinuationActions(UxQueryContext context, @Nullable UxUseCase monitoringUC) {
        UxAction action;
        ArrayList<UxAction> actions = new ArrayList<UxAction>();
        if (monitoringUC != null && (action = new UxActionBuilder(context, UxSchemaInfoQueryMeta.SchemaInfo).withId("SchemaDefDeployedMonitoring").withUseCase(monitoringUC).build()) != null) {
            actions.add(action);
        }
        return actions;
    }
}

