/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.revisions;

import crazydev.common.fs.revision.CdVFileRev;
import crazydev.common.fs.revision.CdVFileRevKind;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.utils.UxRowFilters;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.revisions.UxSchemaDefRevisionQueryMeta;
import crazydev.iccube.ux.builder.queries.revisions.UxSchemaDefRevisionsQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.filter.UxEnumFilterType;
import crazydev.iccube.ux.common.filter.UxFilterMeta;
import crazydev.iccube.ux.common.filter.UxFilterMetas;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableMeta;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableRowSearcher;
import crazydev.iccube.ux.common.table.UxTableSearcher;
import crazydev.iccube.ux.common.table.UxTableSortType;
import crazydev.iccube.ux.common.table.UxTableWithUseCasesReplyPayload;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class UxSchemaDefRevisionsQuery
extends UxSchemaBuilderQuery {
    private final UxTableOptions tableOptions;

    protected UxSchemaDefRevisionsQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId, schemaId);
        this.tableOptions = tableOptions;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            UxBabylonService babylon = queryContext.getUxBabylonService();
            UxTableHeaders header = UxTableHeaders.create(babylon, "schemaDefRevisionNumber", "schemaDefRevisionTimestamp", "schemaDefRevisionBookmark", "schemaDefRevisionOperationBy", "schemaDefRevisionOperation");
            UxFilterMetas filterMetas = new UxFilterMetas(new UxFilterMeta<CdVFileRev>("schemaDefRevisionState", babylon.translate("filterSchemaDefRevisionState", new Serializable[0]), UxEnumFilterType.create(babylon, CdVFileRevKind.class), CdVFileRevKind::from), new UxFilterMeta<CdVFileRev>("schemaDefRevisionBookmark", babylon.translate("filterSchemaDefRevisionBookmark", new Serializable[0]), CdVFileRev::getBookmark), new UxFilterMeta<CdVFileRev>("schemaDefRevisionOperation", babylon.translate("filterSchemaDefRevisionOperation", new Serializable[0]), CdVFileRev::getOperation), new UxFilterMeta<CdVFileRev>("schemaDefRevisionOperationBy", babylon.translate("filterSchemaDefRevisionOperationBy", new Serializable[0]), CdVFileRev::getOperationBy));
            UxTableSearcher rowSearcher = this.setupRowSearcher(this.tableOptions, new UxTableRowSearcher<CdVFileRev>(this){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public boolean isAccepting(CdVFileRev row, String searchText) {
                    return this.isContaining(searchText, row.getRevFileName(), row.getBookmark(), row.getOperation());
                }
            });
            UxRowFilters rowFilters = this.setupRowFilters(this.tableOptions, filterMetas);
            ArrayList revisions = new ArrayList();
            service.forEachSchemaDefRevisions(lock, schema, revision -> {
                if ((rowSearcher == null || rowSearcher.isAccepting(revision)) && (rowFilters == null || rowFilters.isAccepting(revision))) {
                    revisions.add(revision);
                }
            });
            int totalRowCount = revisions.size();
            UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.createForFirstPageWithDefaults(queryContext.getApi(), "schemaDefRevisionNumber", UxTableSortType.desc, totalRowCount));
            ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
            for (CdVFileRev revision2 : revisions) {
                rows.add(UxSchemaDefRevisionsQuery.createRow(queryContext, revision2));
            }
            UxTable table = UxTable.create(options, header, rows);
            List<UxTableRow> actualRows = table.getRows();
            if (actualRows != null) {
                for (UxTableRow actualRow : actualRows) {
                    this.setupRowUseCase(queryContext, actualRow);
                }
            }
            UxTableMeta tableMeta = new UxTableMeta(true, filterMetas);
            return UxReply.success(new UxTableWithUseCasesReplyPayload(tableMeta, table));
        });
    }

    private static UxTableRow createRow(UxQueryContext context, CdVFileRev revision) {
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        cells.add(new UxTableCell(revision.getRevFileNameS()).withValue_(revision.getRevFileNameS_value()));
        String lastModifiedS = revision.getLastModifiedS();
        cells.add(new UxTableCell(Objects.requireNonNullElse(lastModifiedS, "n/a")));
        cells.add(new UxTableCell(revision.getBookmark()));
        cells.add(new UxTableCell(revision.getOperationBy()));
        cells.add(new UxTableCell(revision.getOperation()));
        UxTableRow row = new UxTableRow(cells);
        row.setData(revision);
        return row;
    }

    private void setupRowUseCase(UxQueryContext context, UxTableRow row) {
        UxUseCase useCase = null;
        CdVFileRev revision = (CdVFileRev)row.getData();
        if (revision != null) {
            useCase = UxSchemaDefRevisionQueryMeta.createUseCase(context, this.schemaId, revision.getRevFileName());
        }
        row.setUseCase(useCase);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(UxSchemaDefRevisionsQueryMeta.createUseCase(queryContext, this.schemaId, false));
    }
}

