/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.revisions;

import crazydev.common.fs.revision.CdVFileRev;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.revisions.UxSchemaDefRevisionQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxPropertyTableReplyPayload;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class UxSchemaDefRevisionQuery
extends UxSchemaBuilderQuery {
    private final String revFileName;
    private final UxTableOptions tableOptions;

    protected UxSchemaDefRevisionQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, String revFileName, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId, schemaId);
        this.revFileName = revFileName;
        this.tableOptions = tableOptions;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            UxBabylonService babylon = queryContext.getUxBabylonService();
            boolean isForRestApi = queryContext.isForRestApi();
            UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.create());
            UxTableHeaders header = UxTableHeaders.create(babylon, "property", "value");
            ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
            UxTable table = UxTable.create(options, header, rows);
            CdVFileRev revision = service.getSchemaDefRevision(lock, schema, this.revFileName, false);
            rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "schemaDefRevisionNumber"), revision.getRevFileName()));
            String lastModifiedS = revision.getLastModifiedS();
            rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "schemaDefRevisionTimestamp"), Objects.requireNonNullElse(lastModifiedS, "n/a")));
            rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "schemaDefRevisionBookmark"), revision.getBookmark()));
            rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "schemaDefRevisionOperationBy"), revision.getOperationBy()));
            rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "schemaDefRevisionOperation"), revision.getOperation()));
            return UxReply.success(new UxPropertyTableReplyPayload(table));
        });
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(UxSchemaDefRevisionQueryMeta.createUseCase(queryContext, this.schemaId, this.revFileName));
    }
}

