/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.revdirectories;

import crazydev.common.fs.revision.CdVFileRevFolder;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxBuilderQuery;
import crazydev.iccube.ux.builder.queries.revdirectories.UxBuilderRevDirectoryQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxMessageReplyPayload;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxPropertyTableReplyPayload;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class UxBuilderRevDirectoryQuery
extends UxBuilderQuery {
    @Nullable
    private final UxTableOptions tableOptions;
    private final String relPath;

    protected UxBuilderRevDirectoryQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions, String relPath) {
        super(meta, requestId);
        this.tableOptions = tableOptions;
        this.relPath = relPath;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        boolean isForRestApi = queryContext.isForRestApi();
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        CdVFileRevFolder revDirectory = service.getRevDirectory(this.relPath);
        if (revDirectory == null) {
            return UxReply.success(new UxMessageReplyPayload(babylon.translate("builderRevDirectoryMissing", new Serializable[0])));
        }
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.create());
        UxTableHeaders header = UxTableHeaders.create(babylon, "property", "value");
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        UxTable table = UxTable.create(options, header, rows);
        rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "builderRevDirectory"), this.relPath));
        rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "builderRevDirectorySchemaName"), revDirectory.getInfo()));
        return UxReply.success(new UxPropertyTableReplyPayload(table));
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(UxBuilderRevDirectoryQueryMeta.createUseCase(queryContext, this.relPath));
    }
}

