/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.revdirectories;

import crazydev.common.fs.revision.CdVFileRevFolder;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.utils.UxRowFilters;
import crazydev.iccube.ux.builder.UxBuilderQuery;
import crazydev.iccube.ux.builder.queries.revdirectories.UxBuilderRevDirectoryQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.filter.UxFilterMeta;
import crazydev.iccube.ux.common.filter.UxFilterMetas;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableMeta;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableRowSearcher;
import crazydev.iccube.ux.common.table.UxTableSearcher;
import crazydev.iccube.ux.common.table.UxTableSortType;
import crazydev.iccube.ux.common.table.UxTableWithUseCasesReplyPayload;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class UxBuilderRevDirectoriesQuery
extends UxBuilderQuery {
    @Nullable
    private final UxTableOptions tableOptions;

    protected UxBuilderRevDirectoriesQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId);
        this.tableOptions = tableOptions;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        UxTableHeaders header = UxTableHeaders.create(babylon, "builderRevDirectory", "builderRevDirectorySchemaName");
        UxFilterMetas filterMetas = new UxFilterMetas(new UxFilterMeta<CdVFileRevFolder>("builderRevDirectory", babylon.translate("filterBuilderRevDirectory", new Serializable[0]), CdVFileRevFolder::getRelPath), new UxFilterMeta<CdVFileRevFolder>("builderRevDirectorySchemaName", babylon.translate("filterBuilderRevDirectorySchemaName", new Serializable[0]), CdVFileRevFolder::getInfo));
        UxTableSearcher rowSearcher = this.setupRowSearcher(this.tableOptions, new UxTableRowSearcher<CdVFileRevFolder>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public boolean isAccepting(CdVFileRevFolder row, String searchText) {
                return this.isContaining(searchText, row.getName(), row.getInfo());
            }
        });
        UxRowFilters rowFilters = this.setupRowFilters(this.tableOptions, filterMetas);
        ArrayList revisions = new ArrayList();
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        service.forEachRevDirectory(revDirectory -> {
            if ((rowSearcher == null || rowSearcher.isAccepting(revDirectory)) && (rowFilters == null || rowFilters.isAccepting(revDirectory))) {
                revisions.add(revDirectory);
            }
        });
        revisions.sort((o1, o2) -> {
            String rev1 = o1.getRelPath();
            String rev2 = o2.getRelPath();
            return rev1.compareTo(rev2);
        });
        int totalRowCount = revisions.size();
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.createForFirstPageWithDefaults(queryContext.getApi(), "builderRevDirectory", UxTableSortType.asc, totalRowCount));
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        for (CdVFileRevFolder revision : revisions) {
            rows.add(UxBuilderRevDirectoriesQuery.createRow(queryContext, revision));
        }
        UxTable table = UxTable.create(options, header, rows);
        List<UxTableRow> actualRows = table.getRows();
        if (actualRows != null) {
            for (UxTableRow actualRow : actualRows) {
                this.setupRowUseCase(queryContext, actualRow);
            }
        }
        UxTableMeta tableMeta = new UxTableMeta(true, filterMetas);
        return UxReply.success(new UxTableWithUseCasesReplyPayload(tableMeta, table));
    }

    private static UxTableRow createRow(UxQueryContext context, CdVFileRevFolder revision) {
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        cells.add(new UxTableCell(revision.getRelPath()));
        cells.add(new UxTableCell(revision.getInfo()));
        UxTableRow row = new UxTableRow(cells);
        row.setData(revision);
        return row;
    }

    private void setupRowUseCase(UxQueryContext context, UxTableRow row) {
        UxUseCase useCase = null;
        CdVFileRevFolder revision = (CdVFileRevFolder)row.getData();
        if (revision != null) {
            useCase = UxBuilderRevDirectoryQueryMeta.createUseCase(context, revision.getRelPath());
        }
        row.setUseCase(useCase);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxBuilderUseCaseName.BuilderRevDirectories));
    }
}

