/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.revdirectories;

import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaFactoryFile;
import crazydev.iccube.ux.builder.UxBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.init.UxSchemaBuilderHomeQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaInfo;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import java.io.File;

public class UxBuilderRestoreRevDirectoryQuery
extends UxBuilderQuery {
    private final String relPath;

    protected UxBuilderRestoreRevDirectoryQuery(UxQueryMeta meta, OlapRequestId requestId, String relPath) {
        super(meta, requestId);
        this.relPath = relPath;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        UxBuilderSchemaInfo restoredSchemaInfo = service.restoreRevDirectory(queryContext.getUserName(), this.relPath);
        String restoredSchemaName = restoredSchemaInfo.getSchemaName();
        File restoredSchemaFile = restoredSchemaInfo.getFactoryFile();
        UxSchemaFactoryFile restoredSchemaFactoryFile = UxSchemaFactoryFile.fromFile(queryContext, true, restoredSchemaFile);
        UxSchemaId restoredSchemaId = new UxSchemaId(restoredSchemaName, restoredSchemaFactoryFile.relativePath());
        UxUseCase useCase = new UxUseCaseBuilder(queryContext, UxSchemaBuilderHomeQueryMeta.BuilderHomeS, restoredSchemaId).withId(UxBuilderUseCaseName.BuilderHomeS).build(true);
        return UxReply.actionSuccess(new UxActionContinuation(UxActionContinuationKind.NAVIGATE, useCase));
    }
}

