/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.perspective;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderPerspectiveDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.perspective.UxPerspectiveQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelConverter;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;

public class UxSavePerspectiveQuery
extends UxSchemaBuilderQuery {
    private final String perspectiveName;
    private final UxModel model;

    public UxSavePerspectiveQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, String perspectiveName, UxModel model) {
        super(meta, requestId, schemaId);
        this.perspectiveName = perspectiveName;
        this.model = model;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, this.model.getRevNumber(), (lock, schema) -> {
            String operation;
            UxActionContinuation continuation;
            queryContext.setModelTypeSetupInfo("NAME_WRITE"::equals);
            UxModelConverter converter = queryContext.getUxModelConverterFromUiModel(this.model);
            IOlapBuilderPerspectiveDef perspective = (IOlapBuilderPerspectiveDef)converter.convertToServerModel(queryContext, this.model);
            if (this.model.isPersistent()) {
                if (!this.perspectiveName.equals(perspective.getName())) {
                    IOlapBuilderPerspectiveDef existingPerspective = schema.renamePerspective(lock, this.perspectiveName, perspective.getName());
                    converter.update(existingPerspective, perspective);
                    continuation = new UxActionContinuation(UxActionContinuationKind.NAVIGATE, UxPerspectiveQueryMeta.createUseCase(queryContext, this.schemaId, perspective.getName()));
                    operation = "rename/edit perspective: " + this.perspectiveName + " into: " + perspective.getName();
                } else {
                    IOlapBuilderPerspectiveDef existingPerspective = schema.getPerspective(lock, perspective.getName());
                    if (existingPerspective == null) {
                        return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_FOUND, (Serializable[])new Serializable[]{"perspective", perspective.getName()}));
                    }
                    converter.update(existingPerspective, perspective);
                    continuation = new UxActionContinuation(UxActionContinuationKind.REFRESH);
                    operation = "edit perspective: " + perspective.getName();
                }
            } else {
                schema.insertPerspective(lock, perspective);
                continuation = new UxActionContinuation(UxActionContinuationKind.NAVIGATE, UxPerspectiveQueryMeta.createUseCase(queryContext, this.schemaId, perspective.getName()));
                operation = "add perspective: " + perspective.getName();
            }
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, operation);
            return UxReply.actionSuccess(continuation);
        });
    }
}

