/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.perspective;

import crazydev.iccube.builder.model.def.IOlapBuilderPerspectiveDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.perspective.UxPerspectiveQueryMeta;
import crazydev.iccube.ux.builder.queries.perspective.UxPerspectivesQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.filter.UxFilterMetas;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableMeta;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableRowSearcher;
import crazydev.iccube.ux.common.table.UxTableSortType;
import crazydev.iccube.ux.common.table.UxTableWithUseCasesReplyPayload;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class UxPerspectivesQuery
extends UxSchemaBuilderQuery {
    @Nullable
    private final UxTableOptions tableOptions;

    public UxPerspectivesQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions, UxSchemaId schemaId) {
        super(meta, requestId, schemaId);
        this.tableOptions = tableOptions;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            UxBabylonService babylon = queryContext.getUxBabylonService();
            UxTableHeaders header = UxTableHeaders.create(babylon, "name", "description", "default");
            UxFilterMetas filterMetas = null;
            UxTableRowSearcher<IOlapBuilderPerspectiveDef> searcher = new UxTableRowSearcher<IOlapBuilderPerspectiveDef>(this){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public boolean isAccepting(IOlapBuilderPerspectiveDef row, String searchText) {
                    return this.isContaining(searchText, row.getName());
                }
            };
            List<IOlapBuilderPerspectiveDef> perspectives_ = schema.getSortedPerspectives(lock);
            List<IOlapBuilderPerspectiveDef> perspectives = this.filter(this.tableOptions, searcher, filterMetas, perspectives_);
            int totalRowCount = perspectives.size();
            UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.createForFirstPageWithDefaults(queryContext.getApi(), "name", UxTableSortType.asc, totalRowCount));
            ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
            for (IOlapBuilderPerspectiveDef perspective : perspectives) {
                rows.add(UxPerspectivesQuery.createRow(queryContext, this.schemaId, perspective));
            }
            List<UxAction> multiSelectionActions = UxPerspectivesQueryMeta.createMultiSelectionActions(queryContext, this.schemaId);
            UxTable table = UxTable.create(options, header, rows, multiSelectionActions);
            UxTableMeta tableMeta = new UxTableMeta(searcher != null, filterMetas);
            return UxReply.success(new UxTableWithUseCasesReplyPayload(tableMeta, table));
        });
    }

    private static UxTableRow createRow(UxQueryContext context, UxSchemaId schemaId, IOlapBuilderPerspectiveDef perspective) {
        UxBabylonService babylon = context.getUxBabylonService();
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        UxUseCase useCase = UxPerspectiveQueryMeta.createUseCase(context, schemaId, perspective.getName());
        cells.add(new UxTableCell((Object)perspective.getName(), useCase));
        cells.add(new UxTableCell(perspective.getDescription()));
        boolean isDefault = perspective.isDefault();
        cells.add(new UxTableCell(isDefault ? babylon.translate("yesL", new Serializable[0]) : null));
        return new UxTableRow(cells);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxBuilderUseCaseName.Perspectives, this.schemaId));
    }
}

