/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.measures;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderMeasureDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureGroupReference;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureGroupUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureUniqueName;
import crazydev.iccube.ux.builder.queries.measures.UxMeasureQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.action.UxActionSetup;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelConverter;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import java.io.Serializable;

public class UxSaveMeasureExQuery
extends UxSchemaBuilderQuery {
    private final UxBuilderMeasureGroupUniqueName measureGroupName;
    private final UxModel model;

    public UxSaveMeasureExQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderMeasureGroupUniqueName measureGroupName, UxModel model) {
        super(meta, requestId, schemaId);
        this.measureGroupName = measureGroupName;
        this.model = model;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        if (this.model.isPersistent()) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_PERSISTENT, (Serializable[])new Serializable[0]));
        }
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, this.model.getRevNumber(), (lock, schema) -> {
            UxModelConverter converter = queryContext.getUxModelConverterFromUiModel(this.model);
            IOlapBuilderMeasureDef measure = (IOlapBuilderMeasureDef)converter.convertToServerModel(queryContext, this.model);
            UxBuilderMeasureGroupReference existingMeasureGroup = schema.getExistingMeasureGroup(lock, this.measureGroupName);
            if (existingMeasureGroup.measureGroup.getDefinedMeasure(measure.getName()) != null) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.CUBE_MEASURE_NAME_DUPLICATED, new Serializable[]{measure.getName()});
            }
            existingMeasureGroup.measureGroup.addOrUpdateMeasureForUx(measure);
            UxBuilderMeasureUniqueName measureName = UxBuilderMeasureUniqueName.create(existingMeasureGroup.cube, existingMeasureGroup.measureGroup, measure);
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, "add measure: " + measureName.asString());
            UxUseCase measureUC = UxMeasureQueryMeta.createUseCase(queryContext, UxActionSetup.NONE, this.schemaId, null, measureName);
            return UxReply.actionSuccess(new UxActionContinuation(UxActionContinuationKind.NAVIGATE, measureUC));
        });
    }
}

