/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.measures;

import crazydev.iccube.builder.model.def.IOlapBuilderMeasureDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureGroupReference;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureGroupUniqueName;
import crazydev.iccube.ux.builder.queries.measures.UxCreateMeasureQueryMeta;
import crazydev.iccube.ux.builder.queries.measures.UxSaveMeasureExQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelEditorMode;
import crazydev.iccube.ux.common.model.UxModelReplyPayload;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import org.jetbrains.annotations.Nullable;

public class UxCreateMeasureQuery
extends UxSchemaBuilderQuery {
    private final UxBuilderMeasureGroupUniqueName measureGroupName;
    @Nullable
    private UxBuilderMeasureGroupReference measureGroup;

    public UxCreateMeasureQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderMeasureGroupUniqueName measureGroupName) {
        super(meta, requestId, schemaId);
        this.measureGroupName = measureGroupName;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            this.measureGroup = schema.getExistingMeasureGroup(lock, this.measureGroupName);
            IOlapBuilderMeasureDef measure = this.measureGroup.measureGroup.createEmptyMeasure();
            int revNumber = schema.getRevNumber();
            UxModel model = queryContext.convertToUxModel(revNumber, lock, this.measureGroup.measureGroup, measure, false);
            UxAction save = UxSaveMeasureExQueryMeta.createAction(queryContext, this.schemaId, this.measureGroupName);
            return UxReply.success(new UxModelReplyPayload(model, UxModelEditorMode.EDIT, save));
        });
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        if (this.measureGroup != null) {
            reply.withUseCase(UxCreateMeasureQueryMeta.createUseCase(queryContext, this.schemaId, UxBuilderMeasureGroupUniqueName.create(this.measureGroup.cube, this.measureGroup.measureGroup)));
        }
    }
}

