/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.localization;

import crazydev.iccube.builder.model.def.IOlapBuilderLocalizationDef;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.localization.UxDownloadSchemaLocalizationQueryMeta;
import crazydev.iccube.ux.builder.queries.localization.UxSaveSchemaLocalizationQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelReplyPayload;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.utils.UxUtils;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class UxSchemaLocalizationQuery
extends UxSchemaBuilderQuery {
    public UxSchemaLocalizationQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId) {
        super(meta, requestId, schemaId);
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            int revNumber = schema.getRevNumber();
            IOlapBuilderLocalizationDef localization = schema.getLocalization(lock);
            UxModel model = queryContext.convertToUxModel(revNumber, localization);
            UxAction save = UxSaveSchemaLocalizationQueryMeta.createAction(queryContext, this.schemaId);
            return UxReply.success(new UxModelReplyPayload(model, save));
        });
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        List<UxAction> actions;
        UxUseCase useCase = queryContext.getUseCase(UxBuilderUseCaseName.SchemaLocalization, this.schemaId);
        if (useCase != null && (actions = useCase.getActions()) != null) {
            UxAction download = null;
            Date timestamp = null;
            for (UxAction action : actions) {
                OlapEngineRequestContext engineRequestContext;
                OlapEngineComponent olapEngine;
                OlapSchemaInformation info;
                if (!action.id().equals(UxDownloadSchemaLocalizationQueryMeta.DownloadSchemaLocalization.queryName().name())) continue;
                download = action;
                String schemaName = this.schemaId.schemaName;
                if (schemaName == null || (info = (olapEngine = (engineRequestContext = queryContext.getOlapEngineRequestContext()).getOlapEngineComponent()).getLoadedSchemaInformation(engineRequestContext.asRuntimeContext(), schemaName)) == null) break;
                timestamp = info.getLastDataUpdatedTime();
                break;
            }
            if (download != null) {
                UxBabylonService babylon = queryContext.getUxBabylonService();
                if (timestamp != null) {
                    String ts = UxUtils.formatTimeServer(babylon, timestamp);
                    String now = UxUtils.formatTimeServer(babylon, new Date());
                    download.setSynopsis(babylon.translate("downloadSchemaLocalizationWithMemberWithSchema", new Serializable[]{ts, now}));
                } else {
                    download.setSynopsis(babylon.translate("downloadSchemaLocalizationWithMemberWithoutSchema", new Serializable[0]));
                }
            }
        }
        reply.withUseCase(useCase);
    }
}

