/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.localization;

import crazydev.iccube.builder.model.def.IOlapBuilderLocalizationDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelConverter;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;

public class UxSaveSchemaLocalizationQuery
extends UxSchemaBuilderQuery {
    private final UxModel model;

    public UxSaveSchemaLocalizationQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxModel model) {
        super(meta, requestId, schemaId);
        this.model = model;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, this.model.getRevNumber(), (lock, schema) -> {
            UxModelConverter converter = queryContext.getUxModelConverterFromUiModel(this.model);
            IOlapBuilderLocalizationDef localization = (IOlapBuilderLocalizationDef)converter.convertToServerModel(queryContext, this.model);
            schema.setLocalization(lock, localization);
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, "edit localization");
            return UxReply.actionSuccess();
        });
    }
}

