/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.level;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.builder.model.impl.hierarchy.IOlapBuilderBaseHierarchyLevelDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderLevelReference;
import crazydev.iccube.ux.builder.model.UxBuilderLevelUniqueName;
import crazydev.iccube.ux.builder.queries.level.UxLevelQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelConverter;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;

public class UxSaveLevelQuery
extends UxSchemaBuilderQuery {
    private final UxBuilderLevelUniqueName levelName;
    private final UxModel model;

    public UxSaveLevelQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderLevelUniqueName levelName, UxModel model) {
        super(meta, requestId, schemaId);
        this.levelName = levelName;
        this.model = model;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        if (!this.model.isPersistent()) {
            throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_NOT_PERSISTENT, (Serializable[])new Serializable[0]));
        }
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, this.model.getRevNumber(), (lock, schema) -> {
            String operation;
            UxActionContinuation continuation;
            queryContext.setModelTypeSetupInfo("NAME_WRITE"::equals);
            UxModelConverter converter = queryContext.getUxModelConverterFromUiModel(this.model);
            IOlapBuilderBaseHierarchyLevelDef level = (IOlapBuilderBaseHierarchyLevelDef)converter.convertToServerModel(queryContext, this.model);
            if (!level.getUUID().equals(this.levelName.asUUID())) {
                throw new UxBuilderSchemaServiceException(CdError.create((CdErrorCode)UxErrorCode.BUILDER_MODEL_UUID_MISMATCH, (Serializable[])new Serializable[]{this.levelName.asUUID(), level.getUUID()}));
            }
            if (!this.levelName.getLevelName().equals(level.getName())) {
                UxBuilderLevelReference existingLevel = schema.renameLevel(lock, this.levelName, level.getName());
                converter.update(existingLevel.level, level);
                continuation = new UxActionContinuation(UxActionContinuationKind.NAVIGATE, UxLevelQueryMeta.createUseCase(queryContext, this.schemaId, UxBuilderLevelUniqueName.create(existingLevel.dimension, existingLevel.hierarchy, existingLevel.level)));
                operation = "rename/edit level: " + this.levelName.asString() + " into: " + level.getName();
            } else {
                UxBuilderLevelReference existingLevel = schema.getExistingLevel(lock, this.levelName);
                converter.update(existingLevel.level, level);
                continuation = null;
                operation = "edit level: " + this.levelName.asString();
            }
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, operation);
            return UxReply.actionSuccess(continuation);
        });
    }
}

