/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.level;

import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderLevelUniqueName;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;

public class UxMoveLevelDownQuery
extends UxSchemaBuilderQuery {
    private final UxBuilderLevelUniqueName levelName;

    public UxMoveLevelDownQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderLevelUniqueName levelName) {
        super(meta, requestId, schemaId);
        this.levelName = levelName;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.writeSchema(this.schemaId, -1, (lock, schema) -> {
            schema.moveLevelDown(lock, this.levelName);
            service.saveSchemaDef(queryContext.getUserName(), lock, schema, "move level down: " + this.levelName.asString());
            return UxReply.actionSuccess();
        });
    }
}

