/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.level;

import crazydev.iccube.ux.admin.queries.utils.UxArrays;
import crazydev.iccube.ux.builder.UxSchemaBuilderQueryMeta;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderDimensionUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderHierarchyUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderLevelUniqueName;
import crazydev.iccube.ux.builder.model.UxExtraNavigationKeyId;
import crazydev.iccube.ux.builder.model.UxExtraNavigationNodeId;
import crazydev.iccube.ux.builder.queries.dimension.UxDimensionBrowseQueryMeta;
import crazydev.iccube.ux.builder.queries.level.UxCreateLevelQueryMeta;
import crazydev.iccube.ux.builder.queries.level.UxDeleteLevelQueryMeta;
import crazydev.iccube.ux.builder.queries.level.UxLevelQuery;
import crazydev.iccube.ux.builder.queries.level.UxMoveLevelDownQueryMeta;
import crazydev.iccube.ux.builder.queries.level.UxMoveLevelUpQueryMeta;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionSetup;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxLevelQueryMeta
extends UxSchemaBuilderQueryMeta {
    public static final UxLevelQueryMeta Level = new UxLevelQueryMeta();

    protected UxLevelQueryMeta() {
        super(UxConsoleConstants.QueryName.Level);
    }

    @Override
    protected List<UxAction> doCreateActions(UxQueryContext context, UxSchemaId schemaId) {
        return UxArrays.asList(new UxAction[0]);
    }

    @Override
    protected UxQuery doParseQuery(UxServerRequestParams params, UxSchemaId schemaId) throws UxQueryParserException {
        UxBuilderLevelUniqueName name = params.getExistingLevelNameParameter("name");
        return new UxLevelQuery(this, params.getRequestId(), schemaId, name);
    }

    public UxUrl createQueryUrl(UxSchemaId schemaId, UxBuilderLevelUniqueName name) {
        return this.createQueryUrl(schemaId).addParam("name", name.asUrlParam());
    }

    @Nullable
    public static UxUseCase createUseCase(UxQueryContext context, UxSchemaId schemaId, UxBuilderLevelUniqueName name) {
        return UxLevelQueryMeta.createUseCase(context, UxActionSetup.ALL, schemaId, name);
    }

    @Nullable
    public static UxUseCase createUseCase(UxQueryContext context, UxActionSetup actionSetup, UxSchemaId schemaId, UxBuilderLevelUniqueName name) {
        List<UxAction> actions = null;
        if (actionSetup == UxActionSetup.ALL) {
            actions = Level.createActions(context, schemaId);
            UxBuilderHierarchyUniqueName hierarchyUniqueName = name.getHierarchyUniqueName();
            if (hierarchyUniqueName != null) {
                UxBuilderDimensionUniqueName dimensionUniqueName = hierarchyUniqueName.getDimensionUniqueName();
                if (dimensionUniqueName != null) {
                    actions.add(UxDimensionBrowseQueryMeta.createAction(context, schemaId, dimensionUniqueName));
                }
                actions.add(UxCreateLevelQueryMeta.createAction(context, schemaId, hierarchyUniqueName, 2));
            }
            actions.add(UxMoveLevelUpQueryMeta.createAction(context, schemaId, name));
            actions.add(UxMoveLevelDownQueryMeta.createAction(context, schemaId, name));
            actions.add(UxDeleteLevelQueryMeta.createAction(context, schemaId, name));
        } else if (actionSetup == UxActionSetup.NAVIGATION_TREE) {
            actions = new ArrayList<UxAction>();
            actions.add(UxMoveLevelUpQueryMeta.createAction(context, schemaId, name));
            actions.add(UxMoveLevelDownQueryMeta.createAction(context, schemaId, name));
            actions.add(UxDeleteLevelQueryMeta.createAction(context, schemaId, name));
        }
        UxBabylonService babylon = context.getUxBabylonService();
        UxUrl url = Level.createQueryUrl(schemaId, name);
        return new UxUseCaseBuilder(context, Level, schemaId).withId(UxBuilderUseCaseName.Level, name.getLevelName()).withExtraNavigationKeyId(UxExtraNavigationKeyId.create(UxExtraNavigationNodeId.create(name))).withCaption(babylon.translate("levelUC", new Serializable[]{name.getLevelName()})).withParentId(UxBuilderUseCaseName.SemanticLayer).withUrl(url).withActions(actions).build(actionSetup != UxActionSetup.NONE);
    }
}

