/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.level;

import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderLevelReference;
import crazydev.iccube.ux.builder.model.UxBuilderLevelUniqueName;
import crazydev.iccube.ux.builder.queries.level.UxLevelQueryMeta;
import crazydev.iccube.ux.builder.queries.level.UxSaveLevelQueryMeta;
import crazydev.iccube.ux.builder.queries.tabulardata.UxBrowseTabularDataQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelEditorMode;
import crazydev.iccube.ux.common.model.UxModelReplyPayload;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import org.jetbrains.annotations.Nullable;

public class UxLevelQuery
extends UxSchemaBuilderQuery {
    private final UxBuilderLevelUniqueName name;
    @Nullable
    private UxBuilderLevelReference level;
    @Nullable
    private IOlapBuilderTabularDataDef levelTabularData;

    public UxLevelQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderLevelUniqueName name) {
        super(meta, requestId, schemaId);
        this.name = name;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) throws UxBuilderSchemaServiceException {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            this.level = schema.getExistingLevel(lock, this.name);
            this.levelTabularData = schema.getTabularData(lock, this.level.dimension.getDataTableId());
            queryContext.setupDimensionTableUUID(this.level.dimension.getDataTableId());
            queryContext.setModelTypeSetupInfo("NAME_WRITE"::equals);
            int revNumber = schema.getRevNumber();
            UxModel model = queryContext.convertToUxModel(revNumber, 1, lock, (Object)this.level.dimension, this.level.level, (Boolean)true);
            UxAction save = UxSaveLevelQueryMeta.createAction(queryContext, this.schemaId, this.name);
            return UxReply.success(new UxModelReplyPayload(model, UxModelEditorMode.EDIT, save));
        });
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        if (this.level != null) {
            UxBuilderLevelUniqueName name = UxBuilderLevelUniqueName.create(this.level.dimension, this.level.hierarchy, this.level.level);
            UxUseCase useCase = UxLevelQueryMeta.createUseCase(queryContext, this.schemaId, name);
            if (useCase != null) {
                useCase.addActions(UxBrowseTabularDataQueryMeta.createAction(queryContext, this.schemaId, this.levelTabularData));
            }
            reply.withUseCase(useCase);
        }
    }
}

