/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.builder.queries.level;

import crazydev.iccube.builder.model.impl.hierarchy.IOlapBuilderBaseHierarchyLevelDef;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.builder.UxSchemaBuilderQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderHierarchyReference;
import crazydev.iccube.ux.builder.model.UxBuilderHierarchyUniqueName;
import crazydev.iccube.ux.builder.queries.level.UxCreateLevelQueryMeta;
import crazydev.iccube.ux.builder.queries.level.UxSaveLevelExQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelEditorMode;
import crazydev.iccube.ux.common.model.UxModelReplyPayload;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;

public class UxCreateLevelQuery
extends UxSchemaBuilderQuery {
    private final UxBuilderHierarchyUniqueName hierarchyName;

    public UxCreateLevelQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, UxBuilderHierarchyUniqueName hierarchyName) {
        super(meta, requestId, schemaId);
        this.hierarchyName = hierarchyName;
    }

    @Override
    protected UxReply executeQueryForPersistentSchema(UxQueryContext queryContext) {
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        return service.readSchema(this.schemaId, -1, (lock, schema) -> {
            UxBuilderHierarchyReference hierarchy = schema.getExistingHierarchy(lock, this.hierarchyName);
            IOlapBuilderBaseHierarchyLevelDef level = hierarchy.hierarchy.createEmptyLevel();
            queryContext.setModelTypeSetupInfo("NAME_WRITE"::equals);
            queryContext.setupDimensionTableUUID(hierarchy.dimension.getDataTableId());
            int revNumber = schema.getRevNumber();
            UxModel model = queryContext.convertToUxModel(revNumber, lock, hierarchy.dimension, level, false);
            UxAction save = UxSaveLevelExQueryMeta.createAction(queryContext, this.schemaId, this.hierarchyName);
            return UxReply.success(new UxModelReplyPayload(model, UxModelEditorMode.EDIT, save));
        });
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(UxCreateLevelQueryMeta.createUseCase(queryContext, this.schemaId, this.hierarchyName));
    }
}

